#
# This script was written by Xue Yong Zhi<xueyong@udel.edu>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11340);
 script_bugtraq_id(2222);
 script_version ("$Revision: 8291 $");
 script_tag(name:"cvss_base", value:"3.6");
 script_tag(name:"risk_factor", value:"Medium");
 script_cve_id("CVE-2001-0259");
 
 name = "SSH Secure-RPC Weak Encrypted Authentication";
 script_name(name);
 
 desc = "
You are running SSH Communications Security SSH 1.2.27 - 1.2.30.
 
With Secure-RPC, this version can allow local attackers to recover a 
SUN-DES-1 magic phrase generated by another user, which the attacker 
can use to decrypt that user's private key file.

Solution :
Patch and New version are available from SSH.

Risk factor : Low";
	
 script_description(desc);
 
 summary = "Checks for the remote SSH version";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2003 Xue Yong Zhi");
 family = "Gain a shell remotely";
 script_family(family);
 script_dependencie("ssh_detect.nasl");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/ssh");
if(!port)port = 22;

banner = get_kb_item("SSH/banner/" + port );
if ( ! banner ) exit(0);

#Looking for SSH product version number  < 1.2.30
if(ereg(string:banner, pattern:"SSH-.*-1\.2\.([1-2][0-9]|30)[^0-9]*$", icase:TRUE))security_warning(port);

