##############################################################################
#
#  Novell eDirectory Multiple Vulnerabilities (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/01
#
#  Revision: 1.2
#
#  Log: veerendragg
#  Issue #0159
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900210);
 script_bugtraq_id(30947);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_category(ACT_GATHER_INFO);
 script_family("Buffer overflow");
 script_name("Novell eDirectory Multiple Vulnerabilities (Linux)");
 script_summary("Check for Novell eDirectory version");
 desc = "
 Overview : This host is running Novell eDirectory, which is prone to XSS,
 Denial of Service, and Remote Code Execution Vulnerabilities.

 Vulnerability Insight :

       Multiple flaw are due to,
        - errors in HTTP Protocol Stack that can be exploited to cause heap
          based buffer overflow via a specially crafted language/content-length
          headers.
        - input passed via unspecified parameters to the HTTP Protocol Stack is
          not properly sanitzed before being returned to the user.
        - Multiple unknown error exist in LDAP and NDS services.

        Impact : Successful Remote exploitation will allow execution of 
        arbitrary code, heap-based buffer overflow, Cross Site Scripting 
        attacks, or cause memory corruption.

 Impact Level : System

 Affected Software/OS :
        Novell eDirectory 8.8 SP2 and prior versions on Linux (All).

 Fix : Apply 8.8 Service Pack 3.
 http://download.novell.com/Download?buildid=RH_B5b3M6EQ~

 References : http://secunia.com/advisories/31684
              http://securitytracker.com/alerts/2008/Aug/1020788.html
              http://securitytracker.com/alerts/2008/Aug/1020787.html
              http://securitytracker.com/alerts/2008/Aug/1020786.html
              http://securitytracker.com/alerts/2008/Aug/1020785.html

 CVSS Score :
        CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
        CVSS Temporal Score : 6.9
 Risk factor : High";

 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}

 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
         exit(0);
 }

 port = 8028;
 if(!get_port_state(port))
 {
 	port = 8030;
	if(!get_port_state(port)){
        	exit(0);
 	}
 }

 sock = ssh_login_or_reuse_connection();
 if(!sock){
 	exit(0);
 }

 output = ssh_cmd(socket:sock, cmd:"ndsd --version", timeout:120);
 if("Novell eDirectory" >!< output)
 {
        output = ssh_cmd(socket:sock, timeout:120,
			 cmd:"/opt/novell/eDirectory/sbin/ndsd --version");
 }

 ssh_close_connection();

 if("Novell eDirectory" >!< output){
        exit(0);
 }

 if(!(egrep(pattern:"^Novell eDirectory ([0-7]\..*|8\.[0-7]( .*)?|8\.8( SP[0-2])?)[^.0-9]",
            string:output))){
        exit(0);
 }

 rpmList = get_kb_list("ssh/*/rpms");
 foreach rpm (rpmList)
 {
        if((egrep(pattern:"^novell-AUDTedirinst~(9\.|8\.9\.|8.8.3|[1-9][0-9]+\.)",
                   string:rpm))){
                exit(0);
        }
 }
 security_warning(0);
