##############################################################################
#
#  Google Chrome multiple vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/10
#
#  Revision: 1.1
#
#  Log: veerendragg
#  Issue #0182
#
#  Updated By:
#  Antu Sanadi <santu@secpod.com>
#
#  date update: 2009/08/20
#
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900214);
  script_version("Revision: 1.2 ");
  script_tag(name:"cvss_base", value:"8.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-6994", "CVE-2008-6995", "CVE-2008-6996",
                "CVE-2008-6997", "CVE-2008-698");
  script_bugtraq_id(30975, 30983, 31000, 31029, 31031, 31034, 31035, 31038);
  script_name("Google Chrome multiple vulnerabilities");
  desc = "

  Overview : This host has Google Chrome web browser installed, which is prone
  to arbitrary code execution and Denial of Service vulnerabilities.

  Vulnerability Insight :
  Multiple flaws are due to:
  - the Browser failing to handle specially crafted HTML img tags, certain
    user-supplied data, HTTP view-source headers, and HTML href tags.
  - the Browser allows users to download arbitrary files without confirmation.
  - the Browser fails to perform adequate validation on user supplied data.

  Impact :
  A remote user could cause Denial of Service conditions or can execute arbitrary
  code by convincing the users to visit a malicious website.

  Impact Level : Application

  Affected Software/OS :
  Google Chrome Version 0.2.149.27

  Fix : Upgrade to Google Chrome 0.2.149.29 or later.
  For Updates Refer, http://www.google.com/chrome

  References :
  http://www.milw0rm.com/exploits/6367
  http://evilfingers.com/advisory/google_chrome_poc.php
  http://securitytracker.com/alerts/2008/Sep/1020823.html

  CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(chromeVer != NULL)
{
  # Check for Google Chrome version 0.2.149.27
  if(version_is_equal(version:chromeVer, test_version:"0.2.149.27")){
     security_hole(0);
   }
}

