#
#VID 755fa519-80a9-11dd-8de5-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 755fa519-80a9-11dd-8de5-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61614);
 script_cve_id("CVE-2008-3746");
 script_bugtraq_id(30710);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: neon28";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: neon28

CVE-2008-3746
neon 0.28.0 through 0.28.2 allows remote servers to cause a denial of
service (NULL pointer dereference and crash) via vectors related to
Digest authentication, Digest domain parameter support, and the
parse_domain function.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=476571
http://lists.manyfish.co.uk/pipermail/neon/2008-August/000040.html
http://www.vuxml.org/freebsd/755fa519-80a9-11dd-8de5-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: neon28";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"neon28");
if(!isnull(bver) && revcomp(a:bver, b:"0.28.3")<0) {
    security_note(0, data:"Package neon28 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
