# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8802 (qt)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64717);
 script_cve_id("CVE-2009-1725");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-8802 (qt)");

 desc = "The remote host is missing an update to qt
announced via advisory FEDORA-2009-8802.

Update Information:

Qt's WebKit code did not properly handle numeric character
references, which could allow remote attackers to cause a
denial of service (memory corruption and application crash)
via a crafted HTML document.

Also included is:

* a fix for lib symlinks changing erroneously on upgrades
* a fix for Copy and paste issues
* added support for more x keycodes

ChangeLog:

* Tue Aug 18 2009 Than Ngo  - 4.5.2-2
- security fix for CVE-2009-1725
* Tue Aug 18 2009 Rex Dieter  4.5.2-1.2
- kde-qt: 287-qmenu-respect-minwidth
- kde-qt: 0288-more-x-keycodes (#475247)
* Wed Aug  5 2009 Rex Dieter  4.5.2-1.1
- use linker scripts for _debug targets (#510246)
- apply upstream patch to fix issue in Copy and paste
- optimize (icon-mostly) scriptlets
- -x11: Requires(post,postun): /sbin/ldconfig

References:

[ 1 ] Bug #513813 - CVE-2009-1725: KHTML: improper handling of numeric character references (ACE, DoS)
https://bugzilla.redhat.com/show_bug.cgi?id=513813

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update qt' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8802

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8802 (qt)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"qt", rpm:"qt~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-demos", rpm:"qt-demos~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-devel", rpm:"qt-devel~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-examples", rpm:"qt-examples~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-mysql", rpm:"qt-mysql~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-odbc", rpm:"qt-odbc~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-postgresql", rpm:"qt-postgresql~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-x11", rpm:"qt-x11~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-debuginfo", rpm:"qt-debuginfo~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"qt-doc", rpm:"qt-doc~4.5.2~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
