# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3058 (java-1.6.0-openjdk)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63674);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-3058 (java-1.6.0-openjdk)";
 script_name(name);

 desc = "The remote host is missing an update to java-1.6.0-openjdk
announced via advisory FEDORA-2009-3058.

Update Information:

Updated lcms to 1.18 in openjdk. this fixes many security issues.

ChangeLog:

* Tue Mar 24 2009 Lillian Angel  - 1:1.6.0-13.b14
- Updated java-1.6.0-openjdk-lcms.patch.
* Tue Mar 24 2009 Lillian Angel  - 1:1.6.0-12.b14
- Updated release.
- Added java-1.6.0-openjdk-securitypatches.patch.
* Fri Mar 20 2009 Lillian Angel  - 1:1.6.0-11.b14
- Added java-1.6.0-openjdk-lcms.patch.

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update java-1.6.0-openjdk' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3058

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3058 (java-1.6.0-openjdk)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~1.6.0.0~13.b14.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~demo~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~devel~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~javadoc~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~plugin~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~src~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1.6.0-openjdk", rpm:"java-1.6.0-openjdk~debuginfo~1.6.0.0", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
