# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 546-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53237);
 script_cve_id("CVE-2004-0753", "CVE-2004-0782", "CVE-2004-0788");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 546-1 (gdk-pixbuf)";
 script_name(name);

 desc = "The remote host is missing an update to gdk-pixbuf
announced via advisory DSA 546-1.

Chris Evans discovered several problems in gdk-pixbuf, the GdkPixBuf
library used in Gtk.  It is possible for an attacker to execute
arbitrary code on the victims machine.  Gdk-pixbuf for Gtk+1.2 is an
external package.  For Gtk+2.0 it's part of the main gtk package.

The Common Vulnerabilities and Exposures Project identifies the
following vulnerabilities:

CVE-2004-0753

Denial of service in bmp loader.

CVE-2004-0782

Heap-based overflow in pixbuf_create_from_xpm.

CVE-2004-0788

Integer overflow in the ico loader.

For the stable distribution (woody) these problems have been fixed in
version 0.17.0-2woody2.

For the unstable distribution (sid) these problems have been fixed in
version 0.22.0-7.

We recommend that you upgrade your gdk-pixbuf packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20546-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 546-1 (gdk-pixbuf)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgdk-pixbuf-dev", ver:"0.17.0-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf-gnome-dev", ver:"0.17.0-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf-gnome2", ver:"0.17.0-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgdk-pixbuf2", ver:"0.17.0-2woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
