# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1856-1 (mantis)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64635);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1856-1 (mantis)");

 desc = "The remote host is missing an update to mantis
announced via advisory DSA 1856-1.

It was discovered that the Debian Mantis package, a web based bug
tracking system, installed the database credentials in a file with
world-readable permissions onto the local filesystem. This allows
local users to acquire the credentials used to control the Mantis
database.

This updated package corrects this problem for new installations and
will carefully try to update existing ones. Administrators can check
the permissions of the file /etc/mantis/config_db.php to see if they
are safe for their environment.

The old stable distribution (etch) does not contain a mantis package.

For the stable distribution (lenny), this problem has been fixed in
version 1.1.6+dfsg-2lenny1.

For the unstable distribution (sid), this problem has been fixed in
version 1.1.8+dfsg-2.

We recommend that you upgrade your mantis package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201856-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1856-1 (mantis)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mantis", ver:"1.1.6+dfsg-2lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
