##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import suse

class SuseParserTestCase(unittest.TestCase):

    ## Initial Setup
    suse_parser_obj = suse.Parser()
    ptr = open('./test/unit_test/work/input/2008_34_firefox.html', 'r')
    lines = ptr.readlines()
    ptr.close

    Html_content = "".join(lines)
    setattr(suse_parser_obj, 'Html_content', Html_content)


    def test_getCVE(self):
        print "\nTesting Suse Parser Test Suite ..."
        req_out_put = 'CVE-2008-2798", "CVE-2008-2799", "CVE-2008-2800", "CVE-2008-2801", "CVE-2008-2802", "CVE-2008-2803", "CVE-2008-2805", "CVE-2008-2806", "CVE-2008-2807", "CVE-2008-2808", "CVE-2008-2809", "CVE-2008-2810", "CVE-2008-2811'

        out_put = self.suse_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_fetchHTML(self):
        req_out_put = None

        html_cache = './test/unit_test/work/output/'
        year = '2008'
        main_url = r'./test/unit_test/work/input/advisories/'
        setattr(self.suse_parser_obj, 'html_cache', html_cache)
        setattr(self.suse_parser_obj, 'main_url', main_url)
        out_put = self.suse_parser_obj.fetchHTML(year)
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'SUSE-SA:2008:034'

        out_put = self.suse_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'MozillaFirefox'

        out_put = self.suse_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getImpact(self):
        req_out_put = 'remote code execution'

        out_put = self.suse_parser_obj.getImpact()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription(self):
        req_out_put = "\n  Mozilla Firefox was updated to version 2.0.0.15, fixing various bugs\n  including following security bugs.\n\n  MFSA 2008-21:\n  Mozilla developers identified and fixed several stability bugs in the\n  browser engine used in Firefox and other Mozilla-based products. Some\n  of these crashes showed evidence of memory corruption under certain\n  circumstances and we presume that with enough effort at least some\n  of these could be exploited to run arbitrary code.\n\n  MFSA 2008-22:\n  Mozilla contributor moz_bug_r_a4 submitted a set of vulnerabilities\n  which allow scripts from one document to be executed in the context\n  of a different document. These vulnerabilities could be used by an\n  attacker to violate the same-origin policy and perform an XSS attack.\n\n  MFSA 2008-23:\n  Security researcher Collin Jackson reported a series of vulnerabilities\n  which allow JavaScript to be injected into signed JARs and executed\n  under the context of the JAR's signer. This could allow an attacker\n  to run JavaScript in a victim's browser with the privileges of a\n  different website, provided the attacker possesses a JAR signed by\n  the other website.\n\n  MFSA 2008-24:\n  Mozilla contributor moz_bug_r_a4 reported a vulnerability that\n  allowed non-privileged XUL documents to load chrome scripts from\n  the fastload file.  This could allow an attacker to run arbitrary\n  JavaScript code with chrome privileges.\n\n  MFSA 2008-25:\n  Mozilla contributor moz_bug_r_a4 reported a vulnerability which allows\n  arbitrary JavaScript to be executed with chrome privileges. The\n  privilege escalation was possible because JavaScript loaded via\n  mozIJSSubScriptLoader.loadSubScript() was not using XPCNativeWrappers\n  when accessing content. This could allow an attacker to overwrite\n  trusted objects with arbitrary code which would be executed with\n  chrome privileges when the trusted objects were called by the browser.\n\n  MFSA 2008-27:\n  Opera developer Claudio Santambrogio reported a vulnerability which\n  allows malicious content to force the browser into uploading local\n  files to the remote server. This could be used by an attacker to\n  steal arbitrary files from a victim's computer.\n\n  MFSA 2008-28:\n  Security researcher Gregory Fleischer reported a vulnerability\n  in the way Mozilla indicates the origin of a document to the Java\n  plugin. This vulnerability could allow a malicious Java applet to\n  bypass the same-origin policy and create arbitrary socket connections\n  to other domains.\n\n  MFSA 2008-29:\n  Mozilla developer Daniel Glazman demonstrated that an improperly\n  encoded .properties file in an add-on can result in uninitialized\n  memory being used.  This could potentially result in small chunks of\n  data from other programs being exposed in the browser.\n\n  MFSA 2008-30:\n  Mozilla contributor Masahiro Yamada reported that file URLs in\n  directory listings were not being HTML escaped properly when the\n  filenames contained particular characters. This resulted in files\n  from directory listings being opened in unintended ways or files not\n  being able to be opened by the browser altogether.\n\n  MFSA 2008-31:\n  Mozilla developer John G. Myers reported a weakness in the trust\n  model used by Mozilla regarding alternate names on self-signed\n  certificates. A user could be prompted to accept a self-signed\n  certificate from a website which includes alt-name entries. If\n  the user accepted the certificate, they would also extend trust to\n  any alternate domains listed in the certificate, despite not being\n  prompted about the additional domains. This technique could be used\n  by an attacker to impersonate another server.\n\n  MFSA 2008-32:\n  Mozilla community member Geoff reported a vulnerability in the way\n  Mozilla opens URL files sent directly to the browser. He demonstrated\n  that such files were opened with local file privileges, giving the\n  remote content access to read from the local filesystem. If a user\n  opened a bookmark to a malicious page in this manner, the page could\n  potentially read from other local files on the user's computer.\n\n  MFSA 2008-33:\n  Security research firm Astabis, via the iSIGHT Partners GVP Program,\n  reported a vulnerability in Mozilla's block reflow code. This\n  vulnerability could be used by an attacker to crash the browser and\n  run arbitrary code on the victim's computer."

        out_put = self.suse_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['openSUSE 10.2', 'openSUSE 10.3']

        out_put = self.suse_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getOsLinkDict(self):
        req_out_put = {'openSUSE 10.2': ['update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm', 'update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm'], 'openSUSE 10.3': ['update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm', 'update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm']}

        prod_list = ['openSUSE 10.2', 'openSUSE 10.3']
        out_put = self.suse_parser_obj._getOsLinkDict(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_getRPMDict(self):
        req_out_put = {'openSUSE10.3': ['MozillaFirefox-2.0.0.15-0.1', 'MozillaFirefox-translations-2.0.0.15-0.1'], 'openSUSE10.2': ['MozillaFirefox-2.0.0.15-0.1', 'MozillaFirefox-translations-2.0.0.15-0.1']}

        prod_key_dict = {'openSUSE 10.2': ['update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm', 'update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm'], 'openSUSE 10.3': ['update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm', 'update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm']}
        out_put = self.suse_parser_obj._getRPMDict(prod_key_dict)
        self.assertEquals(out_put, req_out_put)


    def test_cacheRPM(self):
        req_out_put = {'update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm': ['MozillaFirefox-2.0.0.15-0.1.i586.rpm'], 'update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm': ['MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm'], 'update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm': ['MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm'], 'update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm': ['MozillaFirefox-2.0.0.15-0.1.i586.rpm']}

        prod_key_dict = {'openSUSE 10.2': ['update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm', 'update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">ftp://ftp.suse.com/pub/suse/update/10.2/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm'], 'openSUSE 10.3': ['update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-2.0.0.15-0.1.i586.rpm', 'update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm">http://download.opensuse.org/pub/opensuse/update/10.3/rpm/i586/MozillaFirefox-translations-2.0.0.15-0.1.i586.rpm']}
        out_put = self.suse_parser_obj._cacheRPM(prod_key_dict)
        self.assertEquals(out_put, req_out_put)


    def test_getRPM(self):
        req_out_put = {'openSUSE10.3': ['MozillaFirefox-2.0.0.15-0.1', 'MozillaFirefox-translations-2.0.0.15-0.1'], 'openSUSE10.2': ['MozillaFirefox-2.0.0.15-0.1', 'MozillaFirefox-translations-2.0.0.15-0.1']}

        prod_list = ['openSUSE 10.2', 'openSUSE 10.3']
        out_put = self.suse_parser_obj.getRPM(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        prod_list = ['openSUSE 10.2', 'openSUSE 10.3']
        out_put = self.suse_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'http://www.novell.com/linux/security/advisories/2009_08_kernel.html'

        main_url = 'http://www.novell.com/linux/security/advisories/'
        file_name = '2009_08_kernel.html'
        out_put = self.suse_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'http://www.novell.com/linux/security/advisories/2009_08_kernel.html'

        main_url = 'http://www.novell.com/linux/security/advisories'
        file_name = '2009_08_kernel.html'
        out_put = self.suse_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

