# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-728-1 (xulrunner-1.9)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63510);
 script_cve_id("CVE-2009-0040", "CVE-2009-0771", "CVE-2009-0772", "CVE-2009-0773", "CVE-2009-0774", "CVE-2009-0775", "CVE-2009-0776", "CVE-2009-0777");
 script_version ("$");
 name["english"] = "Ubuntu USN-728-1 (xulrunner-1.9)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xulrunner-1.9
announced via advisory USN-728-1.

Details follow:

Glenn Randers-Pehrson discovered that the embedded libpng in Firefox
did not properly initialize pointers. If a user were tricked into
viewing a malicious website with a crafted PNG file, a remote attacker
could cause a denial of service or possibly execute arbitrary code
with the privileges of the user invoking the program. (CVE-2009-0040)

Martijn Wargers, Jesse Ruderman, Josh Soref, Gary Kwong, and Timothee
Groleau discovered flaws in the browser engine. If a user were tricked
into viewing a malicious website, a remote attacker could cause a
denial of service or possibly execute arbitrary code with the
privileges of the user invoking the program. (CVE-2009-0771,
CVE-2009-0772, CVE-2009-0773, CVE-2009-0774)

A flaw was discovered in Firefox's garbage collection process. Under
certain circumstances a remote attacker could exploit this to cause a
denial of service or possibly execute arbitrary code with the
privileges of the user invoking the program. (CVE-2009-0775)

Georgi Guninski discovered a flaw when Firefox performed a
cross-domain redirect. An attacker could bypass the same-origin policy
in Firefox by utilizing nsIRDFService and steal private data from
users authenticated to the redirected website. (CVE-2009-0776)

Masahiro Yamada discovered that Firefox did not display control
characters in the location bar. An attacker could exploit this to
spoof the location bar, such as in a phishing attack. (CVE-2009-0777)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  firefox-3.0                     3.0.7+nobinonly-0ubuntu0.8.04.1
  xulrunner-1.9                   1.9.0.7+nobinonly-0ubuntu0.8.04.1

Ubuntu 8.10:
  abrowser                        3.0.7+nobinonly-0ubuntu0.8.10.1
  firefox-3.0                     3.0.7+nobinonly-0ubuntu0.8.10.1
  xulrunner-1.9                   1.9.0.7+nobinonly-0ubuntu0.8.10.1

After a standard system upgrade you need to restart Firefox and any
applications that use xulrunner, such as Epiphany, to effect the necessary
changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-728-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-728-1 (xulrunner-1.9)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-venkman", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dom-inspector", ver:"1.9.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-venkman", ver:"1.9.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0", ver:"3.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dev", ver:"1.9.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.7+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abrowser", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-venkman", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-granparadiso", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-libthai", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-dom-inspector", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk-venkman", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-trunk", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dom-inspector", ver:"1.9.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-venkman", ver:"1.9.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"abrowser-3.0-branding", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-branding", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-dev", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0-gnome-support", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-3.0", ver:"3.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-dev", ver:"1.9.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9-gnome-support", ver:"1.9.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-1.9", ver:"1.9.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.0.7+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
