# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-703-1 (xterm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63103);
 script_cve_id("CVE-2006-7236", "CVE-2008-2383", "CVE-2008-2382");
 script_version ("$");
 name["english"] = "Ubuntu USN-703-1 (xterm)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xterm
announced via advisory USN-703-1.

Details follow:

Paul Szabo discovered that the DECRQSS escape sequences were not handled
correctly by xterm.  Additionally, window title operations were also not
safely handled.  If a user were tricked into viewing a specially crafted
series of characters while in xterm, a remote attacker could execute
arbitrary commands with user privileges. (CVE-2006-7236, CVE-2008-2382)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  xterm                           208-3.1ubuntu3.1

Ubuntu 7.10:
  xterm                           229-1ubuntu0.1

Ubuntu 8.04 LTS:
  xterm                           229-1ubuntu1.1

Ubuntu 8.10:
  xterm                           235-1ubuntu1.1

After a standard system upgrade you need to restart any running xterms to
effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-703-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-703-1 (xterm)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xterm", ver:"208-3.1ubuntu3.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xterm", ver:"229-1ubuntu0.1", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xterm", ver:"229-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xterm", ver:"235-1ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
