###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_java_dir_server_detect_lin.nasl 1828 2009-04-29 18:00:29Z apr $
#
# Sun Java Directory Server Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900705);
  script_version("$Revision: 1.0 $");
  script_name(english:"Sun Java Directory Server Version Detection (Linux)");
  desc["english"] = "

  Overview: This script detects the version of Directory Server and sets
  the reuslt in KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the version of Java Directory Server");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

dirPaths = find_file(file_name:"directoryserver", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);
foreach dirBin (dirPaths)
{
  dirVer = get_bin_version(full_prog_name:chomp(dirBin), sock:sock,
                           version_argv:"-g",
                           ver_pattern:"Default is: ([0-9]\.[0-9]+)");
  if(dirVer[1] != NULL)
  {
    set_kb_item(name:"Sun/JavaDirServer/Linux/Ver", value:dirVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
