###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pumpkin_tftp_detect.nasl 2135 2009-05-18 20:07:05Z may $
#
# PumpKIN TFTP Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(900647);
  script_version ("$Revision: 1.0 $");
  script_name(english: "PumpKIN TFTP Version Detection");
  desc["english"] = "

  Overview: This script is detects installed version of PumpKIN TFTP and
  sets the result in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets KB of PumpKIN TFTP Version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

pumpKINName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
           "\Uninstall\PumpKIN" , item:"DisplayName");
if(pumpKINName != NULL && "Klever PumpKIN" >< pumpKINName)
{
  pumpKINVer = eregmatch(pattern:"PumpKIN ([0-9.]+)", string:pumpKINName);
  if(pumpKINVer[1] != NULL){
    set_kb_item(name:"PumpKIN/TFTP/Ver", value:pumpKINVer[1]);
  }
}
