##############################################################################
#
#  SMB Could Allow Remote Code Execution Vulnerability (957097)
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/12
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0465
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900057);
  script_bugtraq_id(7385);
  script_cve_id("CVE-2008-4037");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows : Microsoft Bulletins");
  script_name(english:"SMB Could Allow Remote Code Execution Vulnerability (957097)");
  script_summary(english:"Check for Hotfix and version of SMB");
  desc["english"] = "
  MS08-068

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-068.

  Vulnerability Insight:
  Issue exists due to the way that Server Message Block (SMB) Protocol handles
  NTLM credentials when a user connects to an attacker's SMB server.

  Impact: Successful exploitation could allow attacker to replay the user's
  credentials back to them and execute code in the context of the logged-on
  user. They can get complete control of an affected system to view, change,
  or delete data or creating new accounts with full user rights.
  complete control of an affected system.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download
  and update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-068.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms08-068.mspx

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.3
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check Hotfix Missing 957097 (MS08-068)
if(hotfix_missing(name:"957097") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\drivers\Mrxsmb.sys");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Srv.sys version < 5.0.2195.7174
  if(egrep(pattern:"^5\.0\.2195\.([0-6]?[0-9]?[0-9]?[0-9]|7([0][0-9][0-9]|" +
                   "16[0-9]|17[0-3]))$", string:sysVer)){
    security_hole(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Srv.sys < 5.1.2600.3467
    if(egrep(pattern:"^5\.1\.2600\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-3][0-9][0-9]|" +
                     "4([0-5][0-9]|6[0-6])))$", string:sysVer)){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Srv.sys < 5.1.2600.5700
    if(egrep(pattern:"^5\.1\.2600\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-5][0-9][0-9]|" +
                     "6([0-8][0-9]|9[0-9])))$", string:sysVer)){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Srv.sys version < 5.2.3790.3206
    if(egrep(pattern:"^5\.2\.3790\.([0-2]?[0-9]?[0-9]?[0-9]|3[01][0-9][0-9]|" +
                     "32([0][0-5]))$",
             string:sysVer)){
       security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for Srv.sys version < 5.2.3790.4369
    if(egrep(pattern:"^5\.2\.3790\.([0-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9][0-9]|" +
                     "3([0-5][0-9]|6[0-8])))$", string:sysVer)){
       security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
