##############################################################################
#
#  Cumulative Security Update for Internet Explorer (956390)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.0
#
#  Log: schandan
#  Issue #0324
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900054);
  script_bugtraq_id(29960, 31615, 31616, 31617, 31618, 31654);
  script_cve_id("CVE-2008-2947", "CVE-2008-3472", "CVE-2008-3473",
                "CVE-2008-3474", "CVE-2008-3475", "CVE-2008-3476");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("$Revision: 1.0 $");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows : Microsoft Bulletins");
  script_name(english:"Cumulative Security Update for Internet Explorer (956390)");
  script_summary(english:"Check for the vulnerable version of Internet Explorer");
  desc["english"] = "
  MS08-058

  Overview: This host is missing critical security update according to
  Microsoft Bulletin MS08-058.

  Vulnerability Insight:
  Multiple flaws are due to,
  - the browser incorrectly interpreting the origin of scripts when setting the
    Window location object.
  - the browser incorrectly interpreting the origin of scripts when handling
    certain HTML elements.
  - the browser incorrectly interpreting the origin of scripts when handling
    certain events.
  - a memory corruption error when the browser attempts to access an object
    which has not been initialized or has been deleted.
  - a memory corruption error when the browser attempts to access uninitialized
    memory while processing certain HTML objects.

  Impact: Successful exploitation could allow attackers to execute arbitrary
  code via a malicious web page and can gain access to a browser window in
  another domain leading read cookies or cross domain scripting attacks.

  Impact Level: System

  Affected Software/OS:
  Internet Explorer 5.01 & 6 on MS Windows 2000
  Internet Explorer 6 on MS Windows 2003 and XP
  Internet Explorer 7 on MS Windows 2003 and XP

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-058.mspx

  References: http://www.microsoft.com/technet/security/bulletin/ms08-058.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");
include("secpod_ie_supersede.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = registry_get_sz(key:"SOFTWARE\Microsoft\Internet Explorer",
                        item:"Version");
if(!ieVer){
  ieVer = registry_get_sz(item:"IE",
          key:"SOFTWARE\Microsoft\Internet Explorer\Version Vector");
}

if(!ieVer){
  exit(0);
}

if(ie_latest_hotfix_update(bulletin:"MS08-058")){
  exit(0);
}

if(hotfix_missing(name:"956390") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");

dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for IE version 5
  if(ereg(pattern:"^5\..*", string:ieVer))
  {
    # Grep < 5.0.3868.2000
    if(ereg(pattern:"^(5\.0?0\.(([0-2]?[0-9]?[0-9]?[0-9]|3?([0-7]?"+
                    "[0-9]?[0-9]|8?([0-5]?[0-9]|6[0-7])))(\..*)|"+
                    "3868\.[01]?[0-9]?[0-9]?[0-9]))$", string:vers)){
      security_hole(0);
    }
    exit(0);
  }

  # Check for IE version 6
  if(ereg(pattern:"^6\..*", string:ieVer))
  {
    # Grep < 6.0.2800.1615
    if(ereg(pattern:"^(6\.0?0\.(([01]?[0-9]?[0-9]?[0-9]|2?([0-7]?["+
                    "0-9]?[0-9]))(\..*)|2800\.(0?[0-9]?[0-9]?[0-"+
                    "9]|1([0-5][0-9][0-9]|6(0[0-9]|1[0-4])))))$",
            string:vers)){
      security_hole(0);
    }
    exit(0);
  }
}

if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  # Check for IE version 6
  if(ereg(pattern:"^6\..*", string:ieVer))
  {
    if("Service Pack 2" >< SP)
    {
      # Grep < 6.0.2900.3429
      if(ereg(pattern:"^(6\.0?0\.(([01]?[0-9]?[0-9]?[0-9]|2?([0-8]?["+
                      "0-9]?[0-9]))(\..*)|2900\.([0-2]?[0-9]?[0-9]"+
                      "?[0-9]|3([0-3][0-9][0-9]|4([01][0-9]"+
                      "|2[0-8])))))$", string:vers)){
        security_hole(0);
      }
      exit(0);
    }
    if("Service Pack 3" >< SP)
    {
      # Grep < 6.0.2900.5659
      if(ereg(pattern:"^(6\.0?0\.(([01]?[0-9]?[0-9]?[0-9]|2?([0-8]?["+
                      "0-9]?[0-9]))(\..*)|2900\.([0-4]?[0-9]?[0-9]"+
                      "?[0-9]|5([0-5][0-9][0-9]|6([0-4][0-9]"+
                      "|5[0-8])))))$", string:vers)){
        security_hole(0);
      }
      exit(0);
    }
    else security_hole(0);
  }

  # Check for IE version 7
  if(ereg(pattern:"^7\..*", string:ieVer))
  {
    # Grep < 7.0.6000.16735
    if(ereg(pattern:"^(7\.0?0\.([0-5]?[0-9]?[0-9]?[0-9]\..*|6000\."+
                    "(0?[0-9]?[0-9]?[0-9]?[0-9]|1([0-5][0-9]"+
                    "[0-9][0-9]|6([0-6][0-9][0-9]|7[0-2][0-9]|73[0-4])))))$",
            string:vers)){
      security_hole(0);
    }
    exit(0);
  }
}

if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  # Check for IE version 6
  if(ereg(pattern:"^6\..*", string:ieVer))
  {
    if("Service Pack 1" >< SP)
    {
      # Grep < 6.0.3790.3194
      if(ereg(pattern:"(6\.0?0\.(([0-2]?[0-9]?[0-9]?[0-9]|3([0-6]"+
                      "[0-9][0-9]|7[0-8][0-9]))(\..*)|3790\.([0"+
                      "-2]?[0-9]?[0-9]?[0-9]|3(0[0-9][0-9]|1(["+
                      "0-8][0-9]|9[0-3])))))$", string:vers)){
        security_hole(0);
      }
      exit(0);
    }

    if("Service Pack 2" >< SP)
    {
      # Grep < 6.0.3790.4357
      if(ereg(pattern:"(6\.0?0\.(([0-2]?[0-9]?[0-9]?[0-9]|3([0-6]"+
                      "[0-9][0-9]|7[0-8][0-9]))(\..*)|3790\.([0"+
                      "-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9][0-9]|3(["+
                      "0-4][0-9]|5[0-6])))))$", string:vers)){
        security_hole(0);
      }
      exit(0);
    }
    else security_hole(0);
  }
  # Check for IE version 7
  if(ereg(pattern:"^7\..*", string:ieVer))
  {
    # Grep < 7.0.6000.16735
    if(ereg(pattern:"(7\.0?0\.([0-5]?[0-9]?[0-9]?[0-9]\..*|6000\."+
                    "(0?[0-9]?[0-9]?[0-9]?[0-9]|1([0-5][0-9]"+
                    "[0-9][0-9]|6([0-6][0-9][0-9]|7[0-2][0-9]|73[0-4])))))$",
            string:vers)){
       security_hole(0);
    }
    exit(0);
  }
}
