##############################################################################
#
#  Microsoft PowerPoint Could Allow Remote Code Execution Vulnerabilities (949785)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/13
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0113
#
#  Make use of version_func_inc - By Chandan S, 11:48:13 2009/04/24
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900033);
 script_bugtraq_id(30552, 30554, 30579);
 script_cve_id("CVE-2008-0120", "CVE-2008-0121", "CVE-2008-1455");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Windows : Microsoft Bulletins");
 script_name(english:"Microsoft PowerPoint Could Allow Remote Code Execution Vulnerabilities (949785)");
 script_summary(english:"Check for Microsoft PowerPoint file version");
 desc["english"] = "
 MS08-051

 Overview : This host is missing critical security update according to
 Microsoft Bulletin MS08-051.

 Vulnerability Insight :
 Multiple flaw are due to,
 - an integer overflow error when handling CString objects.
 - a memory calculation error when processing malformed picture
   indexes and list values.

 Impact : Remote attackers could be able to corrupt memory locations via
 a specially crafted PowerPoint files.

 Impact Level : System

 Affected Software/OS :
 Microsoft PowerPoint 2002/XP/2003/2007 on Windows (All).
 Microsoft PowerPoint Viewer 2003/2007 on Windows (All).

 Fix : Run Windows Update and update the listed hotfixes or download and
 update mentioned hotfixes in the advisory from the below link.
 http://www.microsoft.com/technet/security/bulletin/ms08-051.mspx

 References : http://www.microsoft.com/technet/security/bulletin/ms08-051.mspx

 CVSS Score :
   CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
   CVSS Temporal Score : 6.1
 Risk factor : High";
 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl", "secpod_office_products_version_900032.nasl",
		     "secpod_ms_office_detection_900025.nasl");
 script_require_keys("SMB/WindowsVersion", "SMB/Office/PowerPnt/Version");
 exit(0);
}


include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(egrep(pattern:"^(9|10|11|12)\..*", string:get_kb_item("MS/Office/Ver")))
{
  pptVer = get_kb_item("SMB/Office/PowerPnt/Version");
  if(!pptVer){
    exit(0);
  }

  if(version_in_range(version:pptVer, test_version:"9.0",
                      test_version2:"9.0.0.8968")){
    security_hole(0);
  }
  else if(version_in_range(version:pptVer, test_version:"10.0",
                           test_version2:"10.0.6841")){
    security_hole(0);
  }
  else if(version_in_range(version:pptVer, test_version:"11.0",
                           test_version2:"11.0.8226")){
    security_hole(0);
  }
  else if(version_in_range(version:pptVer, test_version:"12.0",
                           test_version2:"12.0.6300.4999")){
    security_hole(0);
  }
}
