##############################################################################
#
#  HP OpenView Network Node Manager XSS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/24
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #513
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900403);
  script_bugtraq_id(26838,27237);
  script_cve_id("CVE-2007-5000","CVE-2007-6388");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses : XSS");
  script_name(english:"HP OpenView Network Node Manager XSS Vulnerability");
  script_summary(english:"Check for version of HP OpenView Network Node Manager");
  desc["english"] = "
  Overview:
  This host is running HP OpenView Network Node Manager, which is prone to 
  Cross Site Scripting vulnerability.

  Vulnerability Insight:
  The flaws are caused due to errors in HP OpenView NNM 'Network Node Manager'
  program.

  Impact: 
  Successful exploitation will let the attacker to execute arbitrary codes.

  Impact Level: Application

  Affected Software/OS:
  HP OpenView Network Node Manager versions 7.01, 7.51 and 7.53 on HP-UX, Linux,
  and Solaris.

  Fix : Apply patches or upgrade to the latest version.
  http://welcome.hp.com/country/us/en/support.html

  ******
  NOTE: Windows platform is not affected.
  ******

  References:
  http://secunia.com/Advisories/32800
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2007-5000

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(english:desc["english"]);
  exit(0);
}


include("http_func.inc");

port = 7510;
if(get_port_state(port))
{
  request = http_get(item:"/topology/home", port:port);
  response = http_send_recv(port:port, data:request);

  if("hp OpenView Network Node Manager" >< response &&
     egrep(pattern:"Copyright \(c\).* Hewlett-Packard", string:response) &&
     ereg(pattern:"^HTTP/.* 200 OK", string:response))
  {
    if(egrep(pattern:"NNM Release B\.07\.(01|51|53)", string:response)){
      security_warning(port);
    }
  }
}
