##############################################################################
#
#  freeSSHd SFTP 'rename' and 'realpath' Remote DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/23
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0384
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900165);
  script_bugtraq_id(31872);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_name(english:"freeSSHd SFTP 'rename' and 'realpath' Remote DoS Vulnerability");
  script_summary(english:"Check for vulnerable version of freeSSHd");
  desc["english"] = "
  Overview: The host is running freeSSHd SSH server and is prone to 
  remote denial of service vulnerability.

  NULL pointer de-referencing errors in SFTP 'rename' and 'realpath' commands.
  These can be exploited by passing overly long string passed as an argument to
  the affected commands.

  Impact:
  Successful exploitation will cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  freeSSHd freeSSHd version 1.2.1.14 and prior on Windows (all)

  Fix: No solution/patch is available as on 23rd October, 2008.

  References:
  http://freesshd.com/index.php
  http://milw0rm.com/exploits/6800
  http://secunia.com/advisories/32366/

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:L/Au:SI/C:N/I:N/A:C)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl", "ssh_detect.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports("Services/ssh", 22);
  exit(0);
}


include("secpod_smb_func.inc");

sshdPort = get_kb_item("Services/ssh");
if(!sshdPort){
  sshdPort = 22;
}

# check if FreeSSHd is listening
banner = get_kb_item("SSH/banner/" + sshdPort);
if("WeOnlyDo" >!< banner || "WeOnlyDo-wodFTPD" >< banner){
  exit(0);
} 

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

sshdPath = registry_get_sz(key:"SYSTEM\CurrentControlSet\Services\FreeSSHDService",
                           item:"ImagePath");
if(!sshdPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sshdPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sshdPath);

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

r = smb_session_request(soc:soc, remote:name);
if(!r){
  close(soc);
  exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot){
  close(soc);
  exit(0);
}

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                      prot:prot);
if(!r){
  close(soc);
  exit(0);
}

uid = session_extract_uid(reply:r);
if(!uid){
  close(soc);
  exit(0);
}

r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid){
  close(soc);
  exit(0);
}

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(!fid){
  close(soc);
  exit(0);
}

fileVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid);

# Grep for freeSSHd version 1.2.1.14 and prior
if(egrep(pattern:"^1\.([01](\..*)|2(\.[01](\.[0-9]|\.1[0-4])?)?)$", 
         string:fileVer)){
  security_warning(sshdPort);
}
