##############################################################################
#
#  Adobe Presenter viewer.swf and loadflash.js XSS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/12
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0104
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900110);
 script_bugtraq_id(30615);
 script_cve_id("CVE-2008-3515","CVE-2008-3516");
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses : XSS");			
 script_name(english:"Adobe Presenter viewer.swf and loadflash.js XSS Vulnerability");
 script_summary(english:"Check for the version of Adobe Presenter");
 desc["english"] = "
 Overview : The host is running Adobe Presenter, which prone to to input 
            validation errors which can be exploited by malicious people 
            to conduct cross-site scripting vulnerability.

 Vulnerability Insight :

        Input validation errors in the 'viewer.swf' and 'loadflash.js' files,
        which could be exploited by attackers to execute arbitrary scripting
        code in the user's browser session. 

        Impact : Execution of arbitrary HTML or Scripting code in the security
        context of the affected web site. 

 Impact Level : Application

 Affected Software/OS :
        Adobe Presenter 6.x and 7.x 

 Fix : Upgrade to Adobe Presenter 7.0.1,
 http://www.adobe.com/downloads/

 References :
 http://secunia.com/advisories/31432/
 http://www.frsirt.com/english/advisories/2008/2322
 http://www.adobe.com/support/security/bulletins/apsb08-17.html

 CVSS Score :
        CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N) 
        CVSS Temporal Score : 4.5
 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


 include("smb_nt.inc");

 if(!(get_kb_item("SMB/WindowsVersion"))){
        exit(0);
 }

 if(!registry_key_exists(key:"SOFTWARE\Adobe\Presenter")){
        exit(0);
 }

 adobeVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
				 "\Uninstall\Adobe Presenter 6",
			     item:"DisplayVersion");
 if(!adobeVer)
 {
	adobeVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\Uninstall\Adobe Presenter 7",
                             item:"DisplayVersion");
	if(!adobeVer){
		exit(0);
	}
 }

 if(egrep(pattern:"^(6\..*|7\.0)$", string:adobeVer)){
        	security_warning(0);
 }
