###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# PHP 5.2.8 and Prior Versions Multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# Updated to PHP Get KB Item Method
#   -By Sharath S <sharaths@secpod.com> on 2009-04-17
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100146);
  script_version("$Revision: 1.1 $");
  script_bugtraq_id(33927);
  script_cve_id("CVE-2009-1271");
  script_name(english:"PHP 5.2.8 and Prior Versions Multiple Vulnerabilities");
  desc["english"] = "

  Overview:
  PHP is prone to multiple security vulnerabilities. Successful
  exploits could allow an attacker to cause a denial-of-service
  condition. An unspecified issue with an unknown impact was also
  reported.

  These issues affect PHP 5.2.8 and prior versions.

  Solution:
  The vendor has released PHP 5.2.9 to address these issues. Please
  see http://www.php.net/ fore more information.

  See also:
  http://www.securityfocus.com/bid/33927

  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Determine if php is < 5.2.9");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Michael Meyer");
  script_family(english:"Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");

phpPort = get_kb_item("Services/www");
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Check PHP version < 5.2.9
if(version_is_less(version:phpVer, test_version:"5.2.9")){
  security_warning(phpPort);
}
