#CESA-2009:0308 63431 4
# $Id$
# Description: Auto-generated from advisory CESA-2009:0308 (cups)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63431);
 script_cve_id("CVE-2009-0577", "CVE-2008-3640");
 script_version ("$");
 name["english"] = "CentOS Security Advisory CESA-2009:0308 (cups)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates to cups announced in
advisory CESA-2009:0308.

For details on the issues addressed in this update,
please visit the referenced security advisories.

Solution:
Update the appropriate packages on your system.

http://www.securityspace.com/smysecure/catid.html?in=CESA-2009:0308
http://www.securityspace.com/smysecure/catid.html?in=RHSA-2009:0308
https://rhn.redhat.com/errata/RHSA-2009-0308.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "CentOS Security Advisory CESA-2009:0308 (cups)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "CentOS Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.17~13.3.56", rls:"CentOS3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.17~13.3.56", rls:"CentOS3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.17~13.3.56", rls:"CentOS3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
