###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for postgresql-7.4/-8.0/-8.1 vulnerabilities USN-417-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840130);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "417-1");
  script_cve_id("CVE-2007-0555", "CVE-2007-0556");
  script_name(english: "Ubuntu Update for postgresql-7.4/-8.0/-8.1 vulnerabilities USN-417-1");
  desc["english"] = "

  Vulnerability Insight:

  Jeff Trout discovered that the PostgreSQL server did not sufficiently
  check data types of SQL function arguments in some cases. An
  authenticated attacker could exploit this to crash the database server
  or read out arbitrary locations in the server's memory, which could
  allow retrieving database content the attacker should not be able to
  see. (CVE-2007-0555)
  
  Jeff Trout reported that the query planner did not verify that a table
  was still compatible with a previously made query plan. By using ALTER
  COLUMN TYPE during query execution, an attacker could exploit this to
  read out arbitrary locations in the server's memory, which could allow
  retrieving database content the attacker should not be able to see.
  (CVE-2007-0556)

  Affected Software/OS:
  postgresql-7.4/-8.0/-8.1 vulnerabilities on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-February/000477.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql-7.4/-8.0/-8.1 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.4-0ubuntu1.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.1_8.1.4-7ubuntu0.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecpg5", ver:"8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq-dev", ver:"8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq3", ver:"7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpq4", ver:"8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-client", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plperl", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-plpython", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-pltcl", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.0_8.0.3-15ubuntu2.3", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"postgresql-server-dev", ver:"7.4_7.4.8-17ubuntu1.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}