###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_twiki_tmp_file_handling_vuln.nasl 0456 2008-11-10 14:59:17Z nov $
#
# Insecure tempfile handling Vulnerability in TWiki - Sep08
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800130);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4998");
  script_name(english:"Insecure tempfile handling Vulnerability in TWiki - Sep08");
  desc["english"] = "

  Overview: The host is running TWiki which is prone to Insecure temp file
  handling Vulnerability.

  Vulnerability Insight:
  Local users can overwrite arbitrary files via a symlink attack on the
  /tmp/twiki temporary file.

  Impact:
  Successful attack could lead to rewriting some system file.

  Impact Level: Application

  Affected Software/OS:
  TWiki Version 4.1.2.

  Fix: Upgrade TWiki to higher version.
  http://twiki.org/

  References:
  http://www.openwall.com/lists/oss-security/2008/10/30/2
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=494648

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 4.3
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of TWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

dirs = make_list("/twiki", cgi_dirs());
foreach dir (dirs)
{
  soc = http_open_socket(port);
  if(!soc){
    exit(0);
  }

  sndReq = http_get(item:dir + "/bin/view/TWiki/WebHome", port:port);
  send(socket:soc, data:sndReq);
  rcvRes = http_recv(socket:soc);

  http_close_socket(soc);

  if(rcvRes =~ "Powered by TWiki")
  {
    twikiVer = eregmatch(pattern:"TWiki-([0-9.]+),", string:rcvRes);

    if(twikiVer[1] == "4.1.2"){
      security_warning(port);
    }
    exit(0);
  }
}
