###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for evolution SUSE-SA:2008:028
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850023);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-028");
  script_cve_id("CVE-2008-1108", "CVE-2008-1109");
  script_name(english: "SuSE Update for evolution SUSE-SA:2008:028");
  desc["english"] = "

  Vulnerability Insight:

  Multiple buffer overflows have been fixed in Evolution.

  CVE-2008-1108: A buffer overflow in Evolution, when the ITip
  Formatter plugin is disabled, allows remote attackers potentially
  to execute arbitrary code via a long timezone string in an iCalendar
  attachment.

  CVE-2008-1109: A heap-based buffer overflow in Evolution allows
  user-assisted remote attackers to execute arbitrary code via a long
  DESCRIPTION property in an iCalendar attachment, which is not properly
  handled during a reply in the calendar view (aka the Calendars window).

  Impact:
  remote code execution

  Affected Software/OS:
  evolution on openSUSE 10.2, openSUSE 10.3, Novell Linux Desktop 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SLE SDK 10 SP2, SUSE Linux Enterprise Desktop 10 SP2, SUSE Linux Enterprise 10 SP2 DEBUGINFO

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_28_evolution.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of evolution");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.12.0~5.8", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.12.0~5.8", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.12.0~5.8", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.8.2~11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.8.2~11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.8.2~11", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.4~0.15", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.4~0.15", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.0.4~0.15", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.79", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.79", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.79", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.6.0~49.79", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.66.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.66.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.66.6", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.4~0.15", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.4~0.15", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.0.4~0.15", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.79", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.79", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.79", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.6.0~49.79", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.66.6", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.66.6", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.66.6", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLEDe10SP2")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.4~0.15", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.4~0.15", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.0.4~0.15", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.79", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.79", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.79", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.6.0~49.79", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.66.6", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.66.6", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.66.6", rls:"SLEDe10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP2")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.4~0.15", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.4~0.15", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.0.4~0.15", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.79", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.79", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.79", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.6.0~49.79", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.66.6", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.66.6", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.66.6", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.4~0.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.4~0.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.0.4~0.15", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.79", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.79", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.79", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.6.0~49.79", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.66.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.66.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.66.6", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP2")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.0.4~0.15", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.0.4~0.15", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.0.4~0.15", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.79", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.79", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.79", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-debuginfo", rpm:"evolution-debuginfo~2.6.0~49.79", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.6.0~49.66.6", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.6.0~49.66.6", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.6.0~49.66.6", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}