###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for apache2,apache SUSE-SA:2008:021
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850009);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-021");
  script_cve_id("CVE-2006-3918", "CVE-2007-5000", "CVE-2007-6203", "CVE-2007-6388", "CVE-2007-6421", "CVE-2007-6422", "CVE-2008-0005");
  script_name(english: "SuSE Update for apache2,apache SUSE-SA:2008:021");
  desc["english"] = "

  Vulnerability Insight:

  Various minor bugs have been fixed in the Apache 1 and
  Apache 2 web servers and released as a roll-up update.

  Security problems that were fixed include:

  - cross site scripting problem when processing the 'Expect' header
  CVE-2006-3918 (Apache 1 only)

  - cross site scripting problem in mod_imap CVE-2007-5000
  (Apache 1 and 2)

  - cross site scripting problem in mod_status CVE-2007-6388
  (Apache 1 and 2)

  - cross site scripting problem in the ftp proxy module CVE-2008-0005
  (Apache 1 and 2)

  - cross site scripting problem in the error page for status code 413
  CVE-2007-6203 (Apache 2)

  - cross site scripting problem in mod_proxy_balancer
  CVE-2007-6421 (Apache 2)

  - A flaw in mod_proxy_balancer allowed attackers to crash apache
  CVE-2007-6422 (Apache 2)

  Impact:
  cross site scripting

  Affected Software/OS:
  apache2,apache on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE SLES 9, Novell Linux Desktop 9 SDK, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_21_apache.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of apache2,apache");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.4~70.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.4~70.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.4~70.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.4~70.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.4~70.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-utils", rpm:"apache2-utils~2.2.4~70.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.4~70.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~24", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~24", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~24", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~24", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~24", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~24", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"apache", rpm:"apache~1.3.29~71.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-devel", rpm:"apache-devel~1.3.29~71.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-doc", rpm:"apache-doc~1.3.29~71.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-example-pages", rpm:"apache-example-pages~1.3.29~71.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.8.16~71.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"apache", rpm:"apache~1.3.29~71.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-devel", rpm:"apache-devel~1.3.29~71.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-doc", rpm:"apache-doc~1.3.29~71.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-example-pages", rpm:"apache-example-pages~1.3.29~71.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.8.16~71.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9SDK")
{

  if(isrpmvuln(pkg:"apache", rpm:"apache~1.3.29~71.26", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-devel", rpm:"apache-devel~1.3.29~71.26", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-doc", rpm:"apache-doc~1.3.29~71.26", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-example-pages", rpm:"apache-example-pages~1.3.29~71.26", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.8.16~71.26", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.8", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.8", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.8", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.8", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.8", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.8", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.8", rls:"NLDk9SDK"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~16.17.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~16.17.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~16.17.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~16.17.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~16.17.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~16.17.3", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~16.17.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~16.17.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~16.17.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~16.17.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~16.17.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~16.17.3", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.2.3~16.17.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.2.3~16.17.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.2.3~16.17.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.2.3~16.17.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.2.3~16.17.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.2.3~16.17.3", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"apache", rpm:"apache~1.3.29~71.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-devel", rpm:"apache-devel~1.3.29~71.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-doc", rpm:"apache-doc~1.3.29~71.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache-example-pages", rpm:"apache-example-pages~1.3.29~71.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mod_ssl", rpm:"mod_ssl~2.8.16~71.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libapr0", rpm:"libapr0~2.0.59~1.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2", rpm:"apache2~2.0.59~1.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-devel", rpm:"apache2-devel~2.0.59~1.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-prefork", rpm:"apache2-prefork~2.0.59~1.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-worker", rpm:"apache2-worker~2.0.59~1.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-doc", rpm:"apache2-doc~2.0.59~1.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"apache2-example-pages", rpm:"apache2-example-pages~2.0.59~1.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}