###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for kernel SUSE-SA:2008:007
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850027);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-007");
  script_cve_id("CVE-2007-6151", "CVE-2007-6206", "CVE-2008-0600");
  script_name(english: "SuSE Update for kernel SUSE-SA:2008:007");
  desc["english"] = "

  Vulnerability Insight:

  This kernel update fixes the following critical security problem:

  - CVE-2008-0600: A local privilege escalation was found in the
  vmsplice_pipe system call, which could be used by local attackers
  to gain root access.

  This bug affects the following products:
  - openSUSE 10.2 and 10.3
  - SUSE Linux Enterprise Realtime 10 (SP1)

  Fixed packages have been released for openSUSE 10.2 and 10.3.

  For SUSE Linux Enterprise Realtime 10 packages are being prepared
  currently.

  Since this problem affects Linux kernels starting with 2.6.17 and
  vmsplice was not back-ported, no older products are affected.

  - SUSE Linux Enterprise Server 8, 9, and 10: Not affected.
  - SUSE Linux Enterprise Desktop 10: Not affected.
  - Novell Linux Desktop 9: Not affected.
  - SUSE Linux 10.1: Not affected.


  Following minor security problems were fixed additionally:
  - CVE-2007-6206: Core dumps from root might be accessible to the
  wrong owner. This was fixed for openSUSE 10.3 only.

  - CVE-2007-6151: The isdn_ioctl function in isdn_common.c allowed
  local users to cause a denial of service via a crafted ioctl
  struct in which iocts is not null terminated, which triggers a
  buffer overflow. This problem was fixed for openSUSE 10.2.

  And the following bugs were fixed for openSUSE 10.3 (numbers are
  https://bugzilla.novell.com/ references):

  - Update to minor kernel version 2.6.22.17
  - networking bugfixes
  - contains the following patches which were removed:
  - patches.arch/acpica-psd.patch
  - patches.fixes/invalid-semicolon
  - patches.fixes/nopage-range-fix.patch
  - patches.arch/acpi_thermal_blacklist_add_r50p.patch:
  Avoid critical temp shutdowns on specific ThinkPad R50p
  (https://bugzilla.novell.com/show_bug.cgi?id=333043).
  - patches.rt/megasas_IRQF_NODELAY.patch: Convert megaraid SAS
  IRQ to non-threaded IRQ (337489).
  - patches.drivers/libata-implement-force-parameter added to
  series.conf.
  - patches.xen/xen3-fixup-arch-i386: Xen3 i386 build fixes.
  - patches.xen/xenfb-module-param: Re: Patching Xen virtual
  framebuffer.

  Impact:
  local privilege escalation

  Affected Software/OS:
  kernel on openSUSE 10.2, openSUSE 10.3

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_07_kernel.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-rt", rpm:"kernel-rt~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-rt_debug", rpm:"kernel-rt_debug~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.22.17~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.18.8~0.9", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.18.8~0.9", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-kdump", rpm:"kernel-kdump~2.6.18.8~0.9", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.18.8~0.9", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.18.8~0.9", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.18.8~0.9", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.18.8~0.9", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}