###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for postgresql SUSE-SA:2008:005
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850040);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-005");
  script_cve_id("CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");
  script_name(english: "SuSE Update for postgresql SUSE-SA:2008:005");
  desc["english"] = "

  Vulnerability Insight:

  The database server PostgreSQL had various security problems which
  have been fixed by upgrading to the respective minor versions fixing
  those problems.

  This could have been used by remote attackers having access to the
  SQL server being able to get user rights or corrupt the database.

  Following security issues have been fixed:
  - Index Functions Privilege Escalation: CVE-2007-6600
  - Regular Expression Denial-of-Service: CVE-2007-4772,
  CVE-2007-4769
  - DBLink Privilege Escalation: CVE-2007-6601

  The new PostgreSQL versions are:
  - SUSE Linux Enterprise 10:          8.1.1
  - SUSE Linux Enterprise Server 9:    7.4.19
  - SUSE Linux 10.1 and openSUSE 10.2: 8.1.1
  - openSUSE 10.3:                     8.2.6

  Impact:
  remote code execution

  Affected Software/OS:
  postgresql on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SUSE Linux Enterprise Server 10 SP1

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_05_postgresql.htm

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs-32bit", rpm:"postgresql-libs-32bit~8.2.6~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs-32bit", rpm:"postgresql-libs-32bit~8.1.11~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs-32bit", rpm:"postgresql-libs-32bit~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.1.11~0.2", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~7.4.19~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~7.4.19~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~7.4.19~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~7.4.19~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~7.4.19~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~7.4.19~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~7.4.19~0.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~7.4.19~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~7.4.19~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~7.4.19~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~7.4.19~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~7.4.19~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~7.4.19~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~7.4.19~0.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~7.4.19~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~7.4.19~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~7.4.19~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~7.4.19~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~7.4.19~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~7.4.19~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~7.4.19~0.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs-32bit", rpm:"postgresql-libs-32bit~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.1.11~0.2", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~7.4.19~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~7.4.19~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~7.4.19~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~7.4.19~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~7.4.19~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~7.4.19~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~7.4.19~0.1", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs-32bit", rpm:"postgresql-libs-32bit~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.1.11~0.2", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.11~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.11~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.11~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.11~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-libs", rpm:"postgresql-libs~8.1.11~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.11~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.11~0.2", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}