###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for clamav SUSE-SA:2007:033
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850064);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2007-033");
  script_cve_id("CVE-2007-2650", "CVE-2007-3023", "CVE-2007-3024");
  script_name(english: "SuSE Update for clamav SUSE-SA:2007:033");
  desc["english"] = "

  Vulnerability Insight:

  The anti-virus scan engine ClamAV was upgraded to version 0.90.3 to
  fix several security bugs:

  - Wrong calculation of buffer-end CVE-2007-3023
  - Use strict permissions for temporary files CVE-2007-3024
  - Heap corruption causing denial-of-service with corrupted rar archive
  (no CVE assigned at this time)
  - Detect block list loop in OLE2 scanner CVE-2007-2650

  Updated clamav packages for SUSE Linux Enterprise 10 will be released
  after Service Pack 1 is released.

  Impact:
  remote denial of service

  Affected Software/OS:
  clamav on SUSE LINUX 10.1, openSUSE 10.2, SUSE SLES 9, Open Enterprise Server, Novell Linux POS 9

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2007_33_clamav.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of clamav");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "OES")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.90.3~2.1", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.90.3~2.1", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.90.3~2.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"clamav-db", rpm:"clamav-db~0.90.3~2.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.90.3~2.1", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"clamav", rpm:"clamav~0.90.3~3.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}