###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_qip_icq_message_dos_vuln.nasl 832 2009-03-17 11:28:24Z mar $
#
# Qip ICQ Message Denial Of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800541);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0769");
  script_bugtraq_id(33609);
  script_name(english:"Qip ICQ Message Denial Of Service Vulnerability");
  desc["english"] = "

  Overview: This host is installed with QIP and is prone to denial of
  service vulnerability.

  Vulnerability Insight:
  Issue generated due to an error in handling Rich Text Format ICQ messages.

  Impact:
  Attackers may exploit this issue to crash the application.

  Impact Level: Application

  Affected Software/OS:
  QIP version 2005 build 8082 and prior on Windows

  Fix: Upgrade to latest version
  http://qip.ru/ru/pages/download_qip_ru/

  References:
  http://secunia.com/advisories/33851
  http://www.securityfocus.com/archive/1/archive/1/500656/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of QIP");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_qip_detect.nasl");
  script_require_keys("QIP/Version");
  exit(0);
}


include("version_func.inc");

qipVer = get_kb_item("QIP/Version");
if(!qipVer){
  exit(0);
}

if(version_is_less_equal(version:qipVer, test_version:"8.0.8.2")){
  security_hole(0);
}
