###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for lynx MDVSA-2008:218 (lynx)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830558);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:218");
  script_cve_id("CVE-2008-4690");
  script_name(english: "Mandriva Update for lynx MDVSA-2008:218 (lynx)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability was found in the Lynxcgi: URI handler that could allow
  an attacker to create a web page redirecting to a malicious URL that
  would execute arbitrary code as the user running Lynx, if they were
  using the non-default Advanced user mode (CVE-2008-4690).
  
  This update corrects these issues and, in addition, makes Lynx always
  prompt the user before loading a lynxcgi: URI.  As well, the default
  lynx.cfg configuration file marks all lynxcgi: URIs as untrusted.

  Affected Software/OS:
  lynx on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00046.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of lynx");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"lynx", rpm:"lynx~2.8.6~2.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"lynx", rpm:"lynx~2.8.6~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"lynx", rpm:"lynx~2.8.6~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}