###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for amarok MDVSA-2008:172 (amarok)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830696);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:172");
  script_cve_id("CVE-2008-3699");
  script_name(english: "Mandriva Update for amarok MDVSA-2008:172 (amarok)");
  desc["english"] = "

  Vulnerability Insight:

  A flaw in Amarok prior to 1.4.10 would allow local users to overwrite
  arbitrary files via a symlink attack on a temporary file that Amarok
  created with a predictable name (CVE-2008-3699).
  
  The updated packages have been patched to correct this issue.

  Affected Software/OS:
  amarok on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-08/msg00015.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of amarok");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"amarok-engine-xine", rpm:"amarok-engine-xine~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"amarok-scripts", rpm:"amarok-scripts~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok0", rpm:"libamarok0~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok0-scripts", rpm:"libamarok0-scripts~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok-devel", rpm:"libamarok-devel~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok-scripts-devel", rpm:"libamarok-scripts-devel~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok0", rpm:"lib64amarok0~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok0-scripts", rpm:"lib64amarok0-scripts~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok-devel", rpm:"lib64amarok-devel~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok-scripts-devel", rpm:"lib64amarok-scripts-devel~1.4.7~9.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"amarok", rpm:"amarok~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"amarok-engine-void", rpm:"amarok-engine-void~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"amarok-engine-xine", rpm:"amarok-engine-xine~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"amarok-engine-yauap", rpm:"amarok-engine-yauap~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"amarok-scripts", rpm:"amarok-scripts~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok0", rpm:"libamarok0~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok0-scripts", rpm:"libamarok0-scripts~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok-devel", rpm:"libamarok-devel~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libamarok-scripts-devel", rpm:"libamarok-scripts-devel~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok0", rpm:"lib64amarok0~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok0-scripts", rpm:"lib64amarok0-scripts~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok-devel", rpm:"lib64amarok-devel~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64amarok-scripts-devel", rpm:"lib64amarok-scripts-devel~1.4.8~12.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}