###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for python MDVSA-2008:163 (python)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830740);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:163");
  script_cve_id("CVE-2008-1679", "CVE-2007-4965", "CVE-2008-2315", "CVE-2008-2316", "CVE-2008-3142", "CVE-2008-3143", "CVE-2008-3144");
  script_name(english: "Mandriva Update for python MDVSA-2008:163 (python)");
  desc["english"] = "

  Vulnerability Insight:

  Multiple integer overflows in the imageop module in Python prior to
  2.5.3 allowed context-dependent attackers to cause a denial of service
  (crash) or possibly execute arbitrary code via crafted images that
  trigger heap-based buffer overflows (CVE-2008-1679).  This was due
  to an incomplete fix for CVE-2007-4965.
  
  David Remahl of Apple Product Security reported several integer
  overflows in a number of core modules (CVE-2008-2315).  He also
  reported an integer overflow in the hashlib module on Python 2.5 that
  lead to unreliable cryptographic digest results (CVE-2008-2316).
  
  Justin Ferguson reported multiple buffer overflows in unicode string
  processing that affected 32bit systems (CVE-2008-3142).
  
  Multiple integer overflows were reported by the Google Security Team
  that had been fixed in Python 2.5.2 (CVE-2008-3143).
  
  Justin Ferguson reported a number of integer overflows and underflows
  in the PyOS_vsnprintf() function, as well as an off-by-one error
  when passing zero-length strings, that led to memory corruption
  (CVE-2008-3144).
  
  The updated packages have been patched to correct these issues.
  As well, Python packages on Mandriva Linux 2007.1 and 2008.0 have
  been updated to version 2.5.2.  Due to slight packaging changes on
  Mandriva Linux 2007.1, a new package is available (tkinter-apps) that
  contains binary files (such as /usr/bin/idle) that were previously
  in the tkinter package.

  Affected Software/OS:
  python on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-08/msg00004.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of python");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libpython2.5", rpm:"libpython2.5~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpython2.5-devel", rpm:"libpython2.5-devel~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python", rpm:"python~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-docs", rpm:"python-docs~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter-apps", rpm:"tkinter-apps~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5", rpm:"lib64python2.5~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5-devel", rpm:"lib64python2.5-devel~2.5.2~2.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libpython2.5", rpm:"libpython2.5~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpython2.5-devel", rpm:"libpython2.5-devel~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python", rpm:"python~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-docs", rpm:"python-docs~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter-apps", rpm:"tkinter-apps~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5", rpm:"lib64python2.5~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5-devel", rpm:"lib64python2.5-devel~2.5.2~2.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libpython2.5", rpm:"libpython2.5~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpython2.5-devel", rpm:"libpython2.5-devel~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python", rpm:"python~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-base", rpm:"python-base~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-docs", rpm:"python-docs~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter", rpm:"tkinter~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tkinter-apps", rpm:"tkinter-apps~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5", rpm:"lib64python2.5~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64python2.5-devel", rpm:"lib64python2.5-devel~2.5.2~2.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}