###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kernel MDVSA-2008:105 (kernel)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830754);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:105");
  script_cve_id("CVE-2007-3740", "CVE-2007-3851", "CVE-2007-4133", "CVE-2007-4573", "CVE-2007-4997", "CVE-2007-5093", "CVE-2008-1375", "CVE-2008-1669");
  script_name(english: "Mandriva Update for kernel MDVSA-2008:105 (kernel)");
  desc["english"] = "

  Vulnerability Insight:

  The CIFS filesystem in the Linux kernel before 2.6.22, when Unix
  extension support is enabled, does not honor the umask of a process,
  which allows local users to gain privileges. (CVE-2007-3740)
  
  The drm/i915 component in the Linux kernel before 2.6.22.2, when
  used with i965G and later chipsets, allows local users with access
  to an X11 session and Direct Rendering Manager (DRM) to write
  to arbitrary memory locations and gain privileges via a crafted
  batchbuffer. (CVE-2007-3851)
  
  The (1) hugetlb_vmtruncate_list and (2) hugetlb_vmtruncate functions
  in fs/hugetlbfs/inode.c in the Linux kernel before 2.6.19-rc4 perform
  certain prio_tree calculations using HPAGE_SIZE instead of PAGE_SIZE
  units, which allows local users to cause a denial of service (panic)
  via unspecified vectors. (CVE-2007-4133)
  
  The IA32 system call emulation functionality in Linux kernel 2.4.x
  and 2.6.x before 2.6.22.7, when running on the x86_64 architecture,
  does not zero extend the eax register after the 32bit entry path to
  ptrace is used, which might allow local users to gain privileges by
  triggering an out-of-bounds access to the system call table using
  the %RAX register. This vulnerability is now being fixed in the Xen
  kernel too. (CVE-2007-4573)
  
  Integer underflow in the ieee80211_rx function in
  net/ieee80211/ieee80211_rx.c in the Linux kernel 2.6.x before
  2.6.23 allows remote attackers to cause a denial of service (crash)
  via a crafted SKB length value in a runt IEEE 802.11 frame when
  the IEEE80211_STYPE_QOS_DATA flag is set, aka an off-by-two
  error. (CVE-2007-4997)
  
  The disconnect method in the Philips USB Webcam (pwc) driver in Linux
  kernel 2.6.x before 2.6.22.6 relies on user space to close the device,
  which allows user-assisted local attackers to cause a denial of service
  (USB subsystem hang and CPU consumption in khubd) by not closing the
  device after the disconnect is invoked. NOTE: this rarely crosses
  privilege boundaries, unless the attacker can convince the victim to
  unplug the affected device. (CVE-2007-5093)
  
  A race condition in the directory notification subsystem (dnotify)
  in Linux kernel 2.6.x before 2.6.24.6, and 2.6.25 before 2.6.25.1,
  allows local users to cause a denial of service (OOPS) and possibly
  gain privileges via unspecified vectors. (CVE-2008-1375)
  
  The Linux kernel before 2.6.25.2 does not apply a certain protection
  mechanism for fcntl functionality, which allows local users to (1)
  execute code in parallel or (2) exploit a race condition to obtain
  re-ordered access to the descriptor table. (CVE-2008-1669)
  
  To update your kernel, please follow the directions located at:
  
  http://www.mandriva.com/en/security/kernelupdate

  Affected Software/OS:
  kernel on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00027.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc-latest", rpm:"kernel-doc-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise", rpm:"kernel-enterprise~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise-latest", rpm:"kernel-enterprise-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-latest", rpm:"kernel-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy", rpm:"kernel-legacy~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy-latest", rpm:"kernel-legacy-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-latest", rpm:"kernel-source-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped", rpm:"kernel-source-stripped~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped-latest", rpm:"kernel-source-stripped-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0", rpm:"kernel-xen0~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0-latest", rpm:"kernel-xen0-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.17.18mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU-latest", rpm:"kernel-xenU-latest~2.6.17~18mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}