###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for pulseaudio MDVSA-2008:065 (pulseaudio)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830363);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:065");
  script_cve_id("CVE-2007-1804");
  script_name(english: "Mandriva Update for pulseaudio MDVSA-2008:065 (pulseaudio)");
  desc["english"] = "

  Vulnerability Insight:

  Luigi Auriemma found a few programming errors in Pulseaudio, that
  can be used to crash the Pulseaudio daemon, by authenticated and
  unauthenticated users.
  
  The updated packages fix these issues.

  Affected Software/OS:
  pulseaudio on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-03/msg00010.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pulseaudio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libpulseaudio0", rpm:"libpulseaudio0~0.9.5~1.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulseaudio0-devel", rpm:"libpulseaudio0-devel~0.9.5~1.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulsecore2", rpm:"libpulsecore2~0.9.5~1.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio", rpm:"pulseaudio~0.9.5~1.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseaudio0", rpm:"lib64pulseaudio0~0.9.5~1.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseaudio0-devel", rpm:"lib64pulseaudio0-devel~0.9.5~1.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulsecore2", rpm:"lib64pulsecore2~0.9.5~1.4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}