###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kernel MDKSA-2007:195 (kernel)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830336);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:195");
  script_cve_id("CVE-2007-3105", "CVE-2007-3513", "CVE-2007-3642", "CVE-2007-3848", "CVE-2007-4308", "CVE-2007-4573");
  script_name(english: "Mandriva Update for kernel MDKSA-2007:195 (kernel)");
  desc["english"] = "

  Vulnerability Insight:

  Some vulnerabilities were discovered and corrected in the Linux
  2.6 kernel:
  
  A stack-based buffer overflow in the random number generator could
  allow local root users to cause a denial of service or gain privileges
  by setting the default wakeup threshold to a value greater than the
  output pool size (CVE-2007-3105).
  
  The lcd_write function did not limit the amount of memory used by
  a caller, which allows local users to cause a denial of service
  (memory consumption) (CVE-2007-3513).
  
  The decode_choice function allowed remote attackers to cause a denial
  of service (crash) via an encoded out-of-range index value for a choice
  field which triggered a NULL pointer dereference (CVE-2007-3642).
  
  The Linux kernel allowed local users to send arbitrary signals
  to a child process that is running at higher privileges by
  causing a setuid-root parent process to die which delivered an
  attacker-controlled parent process death signal (PR_SET_PDEATHSIG)
  (CVE-2007-3848).
  
  The aac_cfg_openm and aac_compat_ioctl functions in the SCSI layer
  ioctl patch in aacraid did not check permissions for ioctls, which
  might allow local users to cause a denial of service or gain privileges
  (CVE-2007-4308).
  
  The IA32 system call emulation functionality, when running on the
  x86_64 architecture, did not zero extend the eax register after the
  32bit entry path to ptrace is used, which could allow local users to
  gain privileges by triggering an out-of-bounds access to the system
  call table using the %RAX register (CVE-2007-4573).
  
  In addition to these security fixes, other fixes have been included
  such as:
  
  - More NVidia PCI ids wre added
  - The 3w-9xxx module was updated to version 2.26.02.010
  - Fixed the map entry for ICH8
  - Added the TG3 5786 PCI id
  - Reduced the log verbosity of cx88-mpeg
  
  To update your kernel, please follow the directions located at:
  
  http://www.mandriva.com/en/security/kernelupdate

  Affected Software/OS:
  kernel on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-10/msg00008.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc-latest", rpm:"kernel-doc-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise", rpm:"kernel-enterprise~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise-latest", rpm:"kernel-enterprise-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-latest", rpm:"kernel-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy", rpm:"kernel-legacy~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy-latest", rpm:"kernel-legacy-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-latest", rpm:"kernel-source-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped", rpm:"kernel-source-stripped~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped-latest", rpm:"kernel-source-stripped-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0", rpm:"kernel-xen0~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0-latest", rpm:"kernel-xen0-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.17.16mdv~1~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU-latest", rpm:"kernel-xenU-latest~2.6.17~16mdv", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-enterprise", rpm:"kernel-enterprise~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-legacy", rpm:"kernel-legacy~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-stripped", rpm:"kernel-source-stripped~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen0", rpm:"kernel-xen0~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenU", rpm:"kernel-xenU~2.6.17.16mdv~1~1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}