###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mozilla-firefox MDKSA-2007:126 (mozilla-firefox)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830012);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:126");
  script_cve_id("CVE-2007-1362", "CVE-2007-2867", "CVE-2007-2869", "CVE-2007-2870", "CVE-2007-2871");
  script_name(english: "Mandriva Update for mozilla-firefox MDKSA-2007:126 (mozilla-firefox)");
  desc["english"] = "

  Vulnerability Insight:

  A number of security vulnerabilities have been discovered and corrected
  in the latest Mozilla Firefox program, version 2.0.0.4.
  
  This update provides the latest Firefox to correct these issues.

  Affected Software/OS:
  mozilla-firefox on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00025.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mozilla-firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"deskbar-applet", rpm:"deskbar-applet~2.18.0~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp", rpm:"devhelp~0.13~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp-plugins", rpm:"devhelp-plugins~0.13~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-ecj", rpm:"eclipse-ecj~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-jdt", rpm:"eclipse-jdt~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-jdt-sdk", rpm:"eclipse-jdt-sdk~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-pde", rpm:"eclipse-pde~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-pde-runtime", rpm:"eclipse-pde-runtime~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-pde-sdk", rpm:"eclipse-pde-sdk~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-platform", rpm:"eclipse-platform~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-platform-sdk", rpm:"eclipse-platform-sdk~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-rcp", rpm:"eclipse-rcp~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-rcp-sdk", rpm:"eclipse-rcp-sdk~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse-sdk", rpm:"eclipse-sdk~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"epiphany", rpm:"epiphany~2.18.0~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"epiphany-devel", rpm:"epiphany-devel~2.18.0~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"epiphany-extensions", rpm:"epiphany-extensions~2.18.0~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"galeon", rpm:"galeon~2.0.3~5.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-extras", rpm:"gnome-python-extras~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-gda", rpm:"gnome-python-gda~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-gda-devel", rpm:"gnome-python-gda-devel~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-gdl", rpm:"gnome-python-gdl~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-gksu", rpm:"gnome-python-gksu~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-gtkhtml2", rpm:"gnome-python-gtkhtml2~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-gtkmozembed", rpm:"gnome-python-gtkmozembed~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnome-python-gtkspell", rpm:"gnome-python-gtkspell~2.14.3~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdevhelp-1_0", rpm:"libdevhelp-1_0~0.13~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdevhelp-1_0-devel", rpm:"libdevhelp-1_0-devel~0.13~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmozilla-firefox2.0.0.4", rpm:"libmozilla-firefox2.0.0.4~2.0.0.4~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmozilla-firefox2.0.0.4-devel", rpm:"libmozilla-firefox2.0.0.4-devel~2.0.0.4~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libswt3-gtk2", rpm:"libswt3-gtk2~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtotem-plparser1", rpm:"libtotem-plparser1~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtotem-plparser1-devel", rpm:"libtotem-plparser1-devel~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox", rpm:"mozilla-firefox~2.0.0.4~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"totem", rpm:"totem~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"totem-common", rpm:"totem-common~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"totem-gstreamer", rpm:"totem-gstreamer~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"totem-mozilla", rpm:"totem-mozilla~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"totem-mozilla-gstreamer", rpm:"totem-mozilla-gstreamer~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"yelp", rpm:"yelp~2.18.0~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eclipse", rpm:"eclipse~3.2.2~3.4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64devhelp-1_0", rpm:"lib64devhelp-1_0~0.13~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64devhelp-1_0-devel", rpm:"lib64devhelp-1_0-devel~0.13~3.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox2.0.0.4", rpm:"lib64mozilla-firefox2.0.0.4~2.0.0.4~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox2.0.0.4-devel", rpm:"lib64mozilla-firefox2.0.0.4-devel~2.0.0.4~1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64totem-plparser1", rpm:"lib64totem-plparser1~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64totem-plparser1-devel", rpm:"lib64totem-plparser1-devel~2.18.2~1.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}