###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for php MDKSA-2007:090 (php)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830064);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:090");
  script_cve_id("CVE-2007-1001", "CVE-2007-1285", "CVE-2007-1454", "CVE-2007-1583", "CVE-2007-1718");
  script_name(english: "Mandriva Update for php MDKSA-2007:090 (php)");
  desc["english"] = "

  Vulnerability Insight:

  A heap-based buffer overflow vulnerability was found in PHP's gd
  extension.  A script that could be forced to process WBMP images
  from an untrusted source could result in arbitrary code execution
  (CVE-2007-1001).
  
  A DoS flaw was found in how PHP processed a deeply nested array.
  A remote attacker could cause the PHP intrerpreter to creash
  by submitting an input variable with a deeply nested array
  (CVE-2007-1285).
  
  The internal filter module in PHP in certain instances did not properly
  strip HTML tags, which allowed a remote attacker conduct cross-site
  scripting (XSS) attacks (CVE-2007-1454).
  
  A vulnerability in the way the mbstring extension set global variables
  was discovered where a script using the mb_parse_str() function to
  set global variables could be forced to to enable the register_globals
  configuration option, possibly resulting in global variable injection
  (CVE-2007-1583).
  
  A vulnerability in how PHP's mail() function processed header data was
  discovered.  If a script sent mail using a subject header containing
  a string from an untrusted source, a remote attacker could send bulk
  email to unintended recipients (CVE-2007-1718).
  
  Updated packages have been patched to correct these issues.  Also note
  that the default use of Suhosin helped to protect against some of
  these issues prior to patching.

  Affected Software/OS:
  php on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-04/msg00026.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-filter", rpm:"php-filter~5.2.1~0.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~5.2.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-mbstring", rpm:"php-mbstring~5.2.1~1.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-openssl", rpm:"php-openssl~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-zlib", rpm:"php-zlib~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php", rpm:"php~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.2.1~4.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}