###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for php MDKSA-2007:038 (php)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830303);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:038");
  script_cve_id("CVE-2006-6383", "CVE-2007-0455");
  script_name(english: "Mandriva Update for php MDKSA-2007:038 (php)");
  desc["english"] = "

  Vulnerability Insight:

  PHP 5.2.0 and 4.4 allows local users to bypass safe_mode and
  open_basedir restrictions via a malicious path and a null byte before a
  &quot;;&quot; in a session_save_path argument, followed by an allowed path, which
  causes a parsing inconsistency in which PHP validates the allowed path
  but sets session.save_path to the malicious path. (CVE-2006-6383)
  
  Buffer overflow in the gdImageStringFTEx function in gdft.c in GD
  Graphics Library 2.0.33 and earlier allows remote attackers to cause a
  denial of service (application crash) and possibly execute arbitrary
  code via a crafted string with a JIS encoded font. PHP uses an embedded
  copy of GD and may be susceptible to the same issue. (CVE-2007-0455)
  
  Updated packages have been patched to correct these issues. Users must
  restart Apache for the changes to take effect.

  Affected Software/OS:
  php on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00007.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of php");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.1.6~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.1.6~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.1.6~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.1.6~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.1.6~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~5.1.6~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php", rpm:"php~5.1.6~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.1.6~1.4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.0.4~9.18.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.0.4~9.18.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.0.4~9.18.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.0.4~9.18.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.0.4~9.18.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~5.0.4~2.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"php", rpm:"php~5.0.4~9.18.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.0.4~9.18.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}