###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for postgresql MDKSA-2007:037 (postgresql)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830261);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:037");
  script_cve_id("CVE-2007-0555", "CVE-2007-0556");
  script_name(english: "Mandriva Update for postgresql MDKSA-2007:037 (postgresql)");
  desc["english"] = "

  Vulnerability Insight:

  Jeff Trout discovered that the PostgreSQL server did not sufficiently
  check data types of SQL function arguments in some cases.  A user could
  then exploit this to crash the database server or read out arbitrary
  locations of the server's memory, which could be used to retrieve
  database contents that the user should not be able to see.  Note that a
  user must be authenticated in order to exploit this (CVE-2007-0555).
  
  As well, Jeff Trout also discovered that the query planner did not
  verify that a table was still compatible with a previously-generated
  query plan, which could be exploted to read out arbitrary locations of
  the server's memory by using ALTER COLUMN TYPE during query execution.
  Again, a user must be authenticated in order to exploit this
  (CVE-2007-0556).
  
  Updated packages have been patched to correct these issues.

  Affected Software/OS:
  postgresql on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-02/msg00006.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of postgresql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libecpg5", rpm:"libecpg5~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecpg5-devel", rpm:"libecpg5-devel~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4", rpm:"libpq4~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4-devel", rpm:"libpq4-devel~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpgsql", rpm:"postgresql-plpgsql~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5", rpm:"lib64ecpg5~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5-devel", rpm:"lib64ecpg5-devel~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4", rpm:"lib64pq4~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4-devel", rpm:"lib64pq4-devel~8.1.7~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"libecpg5", rpm:"libecpg5~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecpg5-devel", rpm:"libecpg5-devel~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4", rpm:"libpq4~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpq4-devel", rpm:"libpq4-devel~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql", rpm:"postgresql~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-contrib", rpm:"postgresql-contrib~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-devel", rpm:"postgresql-devel~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-docs", rpm:"postgresql-docs~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-jdbc", rpm:"postgresql-jdbc~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pl", rpm:"postgresql-pl~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plperl", rpm:"postgresql-plperl~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpgsql", rpm:"postgresql-plpgsql~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-plpython", rpm:"postgresql-plpython~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-pltcl", rpm:"postgresql-pltcl~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-server", rpm:"postgresql-server~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"postgresql-test", rpm:"postgresql-test~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5", rpm:"lib64ecpg5~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecpg5-devel", rpm:"lib64ecpg5-devel~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4", rpm:"lib64pq4~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pq4-devel", rpm:"lib64pq4-devel~8.0.11~0.1.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}