###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libmodplug MDKSA-2007:001 (libmodplug)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830009);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:001");
  script_cve_id("CVE-2006-4192");
  script_name(english: "Mandriva Update for libmodplug MDKSA-2007:001 (libmodplug)");
  desc["english"] = "

  Vulnerability Insight:

  Multiple buffer overflows in MODPlug Tracker (OpenMPT) 1.17.02.43 and
  earlier and libmodplug 0.8 and earlier allow user-assisted remote
  attackers to execute arbitrary code via (1) long strings in ITP files
  used by the CSoundFile::ReadITProject function in soundlib/Load_it.cpp
  and (2) crafted modules used by the CSoundFile::ReadSample function in
  soundlib/Sndfile.cpp, as demonstrated by crafted AMF files.
  
  Updated packages are patched to address this issue.

  Affected Software/OS:
  libmodplug on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00000.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libmodplug");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libmodplug0", rpm:"libmodplug0~0.7~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmodplug0-devel", rpm:"libmodplug0-devel~0.7~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmodplug", rpm:"libmodplug~0.7~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64modplug0", rpm:"lib64modplug0~0.7~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64modplug0-devel", rpm:"lib64modplug0-devel~0.7~7.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}