###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for the Ignite-UX or the DynRootDisk (DRD) get_system_info Command HPSBUX02249
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835170);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02249");
  script_cve_id("CVE-2007-4590");
  script_name(english: "HP-UX Update for the Ignite-UX or the DynRootDisk (DRD) get_system_info Command HPSBUX02249");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified in HP-UX running the 
  Ignite-UX or the DynRootDisk (DRD) get_system_info command. This command can 
  change system networking parameters without notification (unqualified 
  configuration change). 

  Impact:
  Local unqualified configuration change

  Affected Software/OS:
  the Ignite-UX or the DynRootDisk (DRD) get_system_info Command on
  HP-UX B.11.11, B.11.23, B.11.31 running the Ignite-UX vC.7.0.212, vC.7.1.93, 
  vC.7.2.94, vC.7.3.144 or the DynRootDisk (DRD) vA.1.0.16.417, vA.1.0.18.245, 
  vA.1.1.0.344, vA.2.0.0.592 get_system_info command. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01118367-4

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of the Ignite-UX or the DynRootDisk (DRD) get_system_info Command");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"Ignite-UX.MGMT-TOOLS", revision:"C.7.3.148", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DRD.DRD-RUN", revision:"A.3.0.0", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Ignite-UX.MGMT-TOOLS", revision:"C.7.3.148", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"DRD.DRD-RUN", revision:"A.3.0.0", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Ignite-UX.MGMT-TOOLS", revision:"C.7.3.148", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}