###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for RPC HPSBUX01020
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835039);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "01020");
  script_cve_id("");
  script_name(english: "HP-UX Update for RPC HPSBUX01020");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  RPC. The vulnerability could be exploited to allow remote Denial of Service 
  (DoS). 

  Impact:
  Remote denial of Service (DoS)

  Affected Software/OS:
  RPC on
  HP-UX B.11.00, B.11.11, B.11.22, B.11.23 running RPC. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00951288-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of RPC");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CLIENT", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-SERVER", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CLIENT", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-SERVER", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NISPLUS2-CORE", patch_list:['PHNE_29449'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_30090'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-CLIENT", patch_list:['PHNE_30091'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS2-SERVER", patch_list:['PHNE_30091'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NISPLUS2-CORE", patch_list:['PHNE_30091'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_30092'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CORE", patch_list:['PHNE_30092'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-SERVER", patch_list:['PHNE_30092'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-CORE", patch_list:['PHNE_30093'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS2-SERVER", patch_list:['PHNE_30094'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CLIENT", patch_list:['PHNE_30808'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_30808'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_30808'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.CORE2-KRN", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CLIENT", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NISPLUS-CORE", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SERVER", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CORE", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CLIENT", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-INETD", patch_list:['PHNE_29210'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"NFS.KEY-CORE", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CLIENT", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-CORE", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-PRG", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SERVER", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-SHLIBS", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CLIENT", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-CORE", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NIS-SERVER", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NISPLUS-CORE", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"NFS.NFS-KRN", patch_list:['PHNE_29211'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}