###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for syslog-ng FEDORA-2008-10752
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860967);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-10752");
  script_cve_id("CVE-2008-5110");
  script_name(english: "Fedora Update for syslog-ng FEDORA-2008-10752");
  desc["english"] = "

  Vulnerability Insight:
  syslog-ng, as the name shows, is a syslogd replacement, but with new
  functionality for the new generation. The original syslogd allows
  messages only to be sorted based on priority/facility pairs; syslog-ng
  adds the possibility to filter based on message contents using regular
  expressions. The new configuration scheme is intuitive and powerful.
  Forwarding logs over TCP and remembering all forwarding hops makes it
  ideal for firewalled environments.


  Affected Software/OS:
  syslog-ng on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg00237.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of syslog-ng");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"syslog-ng", rpm:"syslog-ng~2.0.10~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}