###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for exiv2 FEDORA-2007-4551
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861473);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-4551");
  script_cve_id("CVE-2007-6353");
  script_name(english: "Fedora Update for exiv2 FEDORA-2007-4551");
  desc["english"] = "

  Vulnerability Insight:
  A command line utility to access image metadata, allowing one to:
  * print the Exif metadata of Jpeg images as summary info, interpreted values,
    or the plain data for each tag
  * print the Iptc metadata of Jpeg images
  * print the Jpeg comment of Jpeg images
  * set, add and delete Exif and Iptc metadata of Jpeg images
  * adjust the Exif timestamp (that's how it all started...)
  * rename Exif image files according to the Exif timestamp
  * extract, insert and delete Exif metadata (including thumbnails),
    Iptc metadata and Jpeg comments


  Affected Software/OS:
  exiv2 on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00674.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of exiv2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"exiv2", rpm:"exiv2~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2-libs", rpm:"exiv2-libs~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2-debuginfo", rpm:"exiv2-debuginfo~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2-devel", rpm:"exiv2-devel~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2", rpm:"exiv2~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2", rpm:"exiv2~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2-libs", rpm:"exiv2-libs~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2-debuginfo", rpm:"exiv2-debuginfo~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"exiv2-devel", rpm:"exiv2-devel~0.15~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}