###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bind_sec_bypass_vuln.nasl 825 2009-01-12 15:06:24Z jan $
#
# OpenSSL DSA_verify() Security Bypass Vulnerability in BIND
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800338);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5077", "CVE-2009-0025", "CVE-2009-0265");
  script_bugtraq_id(33150, 33151);
  script_name(english:"OpenSSL DSA_verify() Security Bypass Vulnerability in BIND");
  desc["english"] = "

  Overview: The host is running BIND and is prone to Security Bypass
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper validation of return value from OpenSSL's
  DSA_do_verify and VP_VerifyFinal functions.

  Impact:
  Successful exploitation could allow remote attackers to bypass the certificate
  validation checks and can cause man-in-the-middle attack via signature checks 
  on DSA and ECDSA keys used with SSL/TLS.

  Impact Level: Application

  Affected Software/OS:
  ISC BIND version prior to 9.2 or 9.6.0 P1 or 9.5.1 P1 or 9.4.3 P1 or 9.3.6 P1/Linux

  Fix: Upgrade to version 9.6.0 P1, 9.5.1 P1, 9.4.3 P1, 9.3.6 P1
  https://www.isc.org/downloadables/11

  References:
  https://www.isc.org/node/373
  http://secunia.com/advisories/33404/
  http://www.ocert.org/advisories/ocert-2008-016.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of BIND");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("bind_version.nasl");
  script_require_keys("bind/version");
  exit(0);
}


include("version_func.inc");

udpPort = 53;
if(!get_udp_port_state(udpPort)){
  exit(0);
}

bindVer = get_kb_item("bind/version");
if(!bindVer){
  exit(0);
}

bindVer = eregmatch(pattern:"([0-9.]+)[-| ]?([a-zA-Z0-9]+)?", string:bindVer);
if(bindVer[1] != NULL)
{
  if(bindVer[2] =~ "[a-zA-Z0-9]+"){
    bindVer = bindVer[1] + "." + bindVer[2];
  }
  else
    bindVer = bindVer[1];

  # Check for version < 9.2 or 9.6.0 P1 or 9.5.1 P1 or 9.4.3 P1 or 9.3.6 P1
  if(version_in_range(version:bindVer, test_version:"9.6", test_version2:"9.6.0") ||
     version_in_range(version:bindVer, test_version:"9.5", test_version2:"9.5.1") ||
     version_in_range(version:bindVer, test_version:"9.4", test_version2:"9.4.3") ||
     version_in_range(version:bindVer, test_version:"9.3", test_version2:"9.3.6") ||
     version_is_less(version:bindVer, test_version:"9.2")){
    security_warning(port:udpPort, proto:"udp");
  }
}
