###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_becky_internet_mail_bof_vuln.nasl 1031 2009-02-18 12:05:13Z feb $
#
# Becky! Internet Mail Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800519);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0569");
  script_bugtraq_id(33756);
  script_name(english:"Becky! Internet Mail Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: This host is running Becky! Internet Mail client which is prone
  to buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw is generated when the application fails to perform adequate boundary
  checks on user-supplied input. Boundary error may be generated when the user
  agrees to return a receipt message for a specially crafted e-mail thus
  leading to buffer overflow.

  Impact:
  Successful exploitation will allow a remote attacker to execute arbitrary
  code on the target system and can cause denial-of-service condition.

  Impact level: Application

  Affected Software/OS:
  Becky! Internet Mail version 2.48.2 and prior on Windows.

  Fix: Update to version 2.50.01 or later
  http://www.rimarts.co.jp/becky.htm

  References:
  http://secunia.com/advisories/33892
  http://www.rimarts.jp/downloads/B2/Readme-e.txt

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Becky! Internet Mail");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_becky_internet_mail_detect.nasl");
  script_require_keys("Becky/InternetMail/Ver");
  exit(0);
}


include("version_func.inc");

bimVer = get_kb_item("Becky/InternetMail/Ver");
if(bimVer == NULL){
  exit(0);
}

# Grep for version 2.48.02 (2.4.8.2)
if(version_is_less_equal(version:bimVer, test_version:"2.4.8.2")){
  security_hole(0);
}
