###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_tomcat_xss_vuln.nasl 864 2009-03-12 19:46:34Z mar $
#
# Apache Tomcat cal2.jsp Cross Site Scripting Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800372);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0781");
  script_name(english:"Apache Tomcat cal2.jsp Cross Site Scripting Vulnerability");
  desc["english"] = "

  Overview:
  This host is running Apache Tomcat and is prone to Cross Site Scripting
  vulnerability.

  Vulnerability Insight:
  The issue is due to input validation error in time parameter in
  'jsp/cal/cal2.jsp' file in calendar application.

  Impact:
  Successful exploitation will allow remote attackers to inject arbitrary HTML
  codes in the context of the affected web application.

  Impact Level: Application

  Affected Software/OS:
  Apache Tomcat version 4.1.0 to 4.1.39, 5.5.0 to 5.5.27 and 6.0.0 to 6.0.18

  Fix:
  Update your cal2.jsp through SVN.
  Revision numbers are 750924 or 750928.
  http://tomcat.apache.org/security-6.html
  http://tomcat.apache.org/security-5.html
  http://tomcat.apache.org/security-4.html

  References:
  http://www.packetstormsecurity.org/0903-exploits/CVE-2009-0781.txt
  http://www.securityfocus.com/archive/1/archive/1/501538/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check version of Apache Tomcat or XSS Check");
  script_category(ACT_MIXED_ATTACK);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_dependencies("gb_apache_tomcat_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}

include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:8080);
tomcatVer = get_kb_item("www/" + port + "/ApacheTomcat");
if(tomcatVer == NULL){
  exit(0);
}

if(!safe_checks())
{
  # XSS attack string test in 'time' parameter inside cal2.jsp page
  sndReq = string("GET /jsp-examples/cal/cal2.jsp?time=%74%65%73%74%3C%73%63%72%69"+
                  "%70%74%3E%61%6C%65%72%74%28%22%61%74%74%61%63%6B%22%29%3B%3C" +
                  "%2F%73%63%72%69%70%74%3E \r\n\r\n");
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);
  if(rcvRes == NULL){
    exit(0);
  }

  if("test" >< rcvRes && "attack" >< rcvRes)
  {
    security_warning(port);
    exit(0);
  }
}

if(version_in_range(version:tomcatVer, test_version:"4.1.0", test_version2:"4.1.39") ||
   version_in_range(version:tomcatVer, test_version:"5.5.0", test_version2:"5.5.27") ||
   version_in_range(version:tomcatVer, test_version:"6.0.0", test_version2:"6.0.18")){
  security_warning(port);
}
