###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_alpine_tmail_n_dmail_bof_vuln_win.nasl 2008-12-04 11:59:24Z dec $
#
# Alpine tmail and dmail Buffer Overflow Vulnerabilities (Win)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800150);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5005");
  script_bugtraq_id(32072);
  script_name(english:"Alpine tmail and dmail Buffer Overflow Vulnerabilities (Win)");
  desc["english"] = "

  Overview: The host has Alpine installed and is prone to Buffer Overflow
  Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to boundary error in the tmail/dmail utility,
  when processing overly long mailbox names composed of a username and +
  character followed by a long string and also by specifying a long folder
  extension argument on the command line.

  Impact:
  Successful exploitation allows execution of arbitrary code, but requires
  that the utilities are configured as a delivery backend for a mail transfer
  agent allowing overly long destination mailbox names.

  Impact Level: Application

  Affected Software/OS:
  University of Washington Alpine 2.00 and priror on Windows.

  Fix: Update to higher Version or Apply patches from,
  http://www.washington.edu/alpine/tmailbug.html

  *****
  NOTE : Ignore this warning, if above mentioned patch is applied already.
  *****

  References:
  http://www.washington.edu/alpine/
  http://secunia.com/advisories/32483
  http://www.frsirt.com/english/advisories/2008/3042/products

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Alpine");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

apVer = registry_get_sz(item:"DisplayName",
        key:"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Alpine_is1");
if(!apVer){
  exit(0);
}

apVer = apVer - "Alpine ";
if(version_is_less_equal(version:apVer, test_version:"2.00")){
  security_hole(0);
}
