###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for gnutls RHSA-2008:0982-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870055);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0982-01");
  script_cve_id("CVE-2008-4989");
  script_name(english: "RedHat Update for gnutls RHSA-2008:0982-01");
  desc["english"] = "

  Vulnerability Insight:
  The GnuTLS library provides support for cryptographic algorithms and for
  protocols such as Transport Layer Security (TLS). 
  
  Martin von Gagern discovered a flaw in the way GnuTLS verified certificate
  chains provided by a server. A malicious server could use this flaw to
  spoof its identity by tricking client applications using the GnuTLS library
  to trust invalid certificates. (CVE-2008-4989)
  
  Users of GnuTLS are advised to upgrade to these updated packages, which
  contain a backported patch that corrects this issue.


  Affected Software/OS:
  gnutls on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-November/msg00004.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnutls");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~1.4.1~3.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-debuginfo", rpm:"gnutls-debuginfo~1.4.1~3.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~1.4.1~3.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gnutls-utils", rpm:"gnutls-utils~1.4.1~3.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}